/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class Key {
    private final AttributeValue partitionKeyValue;
    private final AttributeValue sortKeyValue;

    private Key(AttributeValue partitionKeyValue, AttributeValue sortKeyValue) {
        this.partitionKeyValue = partitionKeyValue;
        this.sortKeyValue = sortKeyValue;
    }

    public static Key create(AttributeValue partitionKeyValue) {
        return new Key(partitionKeyValue, null);
    }

    public static Key create(AttributeValue partitionKeyValue, AttributeValue sortKeyValue) {
        return new Key(partitionKeyValue, sortKeyValue);
    }

    public Map<String, AttributeValue> keyMap(TableSchema<?> tableSchema, String index) {
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put(tableSchema.tableMetadata().indexPartitionKey(index), this.partitionKeyValue);
        if (this.sortKeyValue != null) {
            keyMap.put(tableSchema.tableMetadata().indexSortKey(index).orElseThrow(() -> new IllegalArgumentException("A sort key value was supplied for an index that does not support one. Index: " + index)), this.sortKeyValue);
        }
        return Collections.unmodifiableMap(keyMap);
    }

    public AttributeValue partitionKeyValue() {
        return this.partitionKeyValue;
    }

    public Optional<AttributeValue> sortKeyValue() {
        return Optional.ofNullable(this.sortKeyValue);
    }

    public Map<String, AttributeValue> primaryKeyMap(TableSchema<?> tableSchema) {
        return this.keyMap(tableSchema, TableMetadata.primaryIndexName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (this.partitionKeyValue != null ? !this.partitionKeyValue.equals((Object)key.partitionKeyValue) : key.partitionKeyValue != null) {
            return false;
        }
        return this.sortKeyValue != null ? this.sortKeyValue.equals((Object)key.sortKeyValue) : key.sortKeyValue == null;
    }

    public int hashCode() {
        int result = this.partitionKeyValue != null ? this.partitionKeyValue.hashCode() : 0;
        result = 31 * result + (this.sortKeyValue != null ? this.sortKeyValue.hashCode() : 0);
        return result;
    }
}

