/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.ConditionCheck;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.PutItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.DeleteItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.PutItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.UpdateItemOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;

@SdkPublicApi
public final class TransactWriteItemsEnhancedRequest {
    private final List<TransactWriteItem> transactWriteItems;

    private TransactWriteItemsEnhancedRequest(Builder builder) {
        this.transactWriteItems = Utils.getItemsFromSupplier(builder.itemSupplierList);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<TransactWriteItem> transactWriteItems() {
        return this.transactWriteItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactWriteItemsEnhancedRequest that = (TransactWriteItemsEnhancedRequest)o;
        return this.transactWriteItems != null ? this.transactWriteItems.equals(that.transactWriteItems) : that.transactWriteItems == null;
    }

    public int hashCode() {
        return this.transactWriteItems != null ? this.transactWriteItems.hashCode() : 0;
    }

    public static final class Builder {
        private List<Supplier<TransactWriteItem>> itemSupplierList = new ArrayList<Supplier<TransactWriteItem>>();

        private Builder() {
        }

        public <T> Builder addConditionCheck(MappedTableResource<T> mappedTableResource, ConditionCheck<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, request));
            return this;
        }

        public <T> Builder addConditionCheck(MappedTableResource<T> mappedTableResource, Consumer<ConditionCheck.Builder> requestConsumer) {
            ConditionCheck.Builder builder = ConditionCheck.builder();
            requestConsumer.accept(builder);
            return this.addConditionCheck(mappedTableResource, builder.build());
        }

        public <T> Builder addDeleteItem(MappedTableResource<T> mappedTableResource, DeleteItemEnhancedRequest request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, DeleteItemOperation.create(request)));
            return this;
        }

        public <T> Builder addDeleteItem(MappedTableResource<T> mappedTableResource, Consumer<DeleteItemEnhancedRequest.Builder> requestConsumer) {
            DeleteItemEnhancedRequest.Builder builder = DeleteItemEnhancedRequest.builder();
            requestConsumer.accept(builder);
            return this.addDeleteItem(mappedTableResource, builder.build());
        }

        public <T> Builder addPutItem(MappedTableResource<T> mappedTableResource, PutItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, PutItemOperation.create(request)));
            return this;
        }

        public <T> Builder addPutItem(MappedTableResource<T> mappedTableResource, Class<? extends T> itemClass, Consumer<PutItemEnhancedRequest.Builder<T>> requestConsumer) {
            PutItemEnhancedRequest.Builder<T> builder = PutItemEnhancedRequest.builder(itemClass);
            requestConsumer.accept(builder);
            return this.addPutItem(mappedTableResource, builder.build());
        }

        public <T> Builder addUpdateItem(MappedTableResource<T> mappedTableResource, UpdateItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, UpdateItemOperation.create(request)));
            return this;
        }

        public <T> Builder addUpdateItem(MappedTableResource<T> mappedTableResource, Class<? extends T> itemClass, Consumer<UpdateItemEnhancedRequest.Builder<T>> requestConsumer) {
            UpdateItemEnhancedRequest.Builder<T> builder = UpdateItemEnhancedRequest.builder(itemClass);
            requestConsumer.accept(builder);
            return this.addUpdateItem(mappedTableResource, builder.build());
        }

        public TransactWriteItemsEnhancedRequest build() {
            return new TransactWriteItemsEnhancedRequest(this);
        }

        private <T> TransactWriteItem generateTransactWriteItem(MappedTableResource<T> mappedTableResource, TransactableWriteOperation<T> generator) {
            return generator.generateTransactWriteItem(mappedTableResource.tableSchema(), OperationContext.create(mappedTableResource.tableName()), mappedTableResource.mapperExtension());
        }
    }
}

