/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DynamoDbEnhancedClient;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.DefaultDynamoDbTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchGetItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchGetResultPage;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchWriteItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchWriteResult;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.TransactGetItemsEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.TransactGetResultPage;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.TransactWriteItemsEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.BatchGetItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.BatchWriteItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.TransactGetItemsOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.TransactWriteItemsOperation;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public final class DefaultDynamoDbEnhancedClient
implements DynamoDbEnhancedClient {
    private final DynamoDbClient dynamoDbClient;
    private final MapperExtension mapperExtension;

    private DefaultDynamoDbEnhancedClient(DynamoDbClient dynamoDbClient, MapperExtension mapperExtension) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> DefaultDynamoDbTable<T> table(String tableName, TableSchema<T> tableSchema) {
        return new DefaultDynamoDbTable<T>(this.dynamoDbClient, this.mapperExtension, tableSchema, tableName);
    }

    @Override
    public SdkIterable<BatchGetResultPage> batchGetItem(BatchGetItemEnhancedRequest request) {
        BatchGetItemOperation operation = BatchGetItemOperation.create(request);
        return operation.execute(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public SdkIterable<BatchGetResultPage> batchGetItem(Consumer<BatchGetItemEnhancedRequest.Builder> requestConsumer) {
        BatchGetItemEnhancedRequest.Builder builder = BatchGetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.batchGetItem(builder.build());
    }

    @Override
    public BatchWriteResult batchWriteItem(BatchWriteItemEnhancedRequest request) {
        BatchWriteItemOperation operation = BatchWriteItemOperation.create(request);
        return (BatchWriteResult)operation.execute(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public BatchWriteResult batchWriteItem(Consumer<BatchWriteItemEnhancedRequest.Builder> requestConsumer) {
        BatchWriteItemEnhancedRequest.Builder builder = BatchWriteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.batchWriteItem(builder.build());
    }

    @Override
    public List<TransactGetResultPage> transactGetItems(TransactGetItemsEnhancedRequest request) {
        TransactGetItemsOperation operation = TransactGetItemsOperation.create(request);
        return (List)operation.execute(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public List<TransactGetResultPage> transactGetItems(Consumer<TransactGetItemsEnhancedRequest.Builder> requestConsumer) {
        TransactGetItemsEnhancedRequest.Builder builder = TransactGetItemsEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.transactGetItems(builder.build());
    }

    @Override
    public Void transactWriteItems(TransactWriteItemsEnhancedRequest request) {
        TransactWriteItemsOperation operation = TransactWriteItemsOperation.create(request);
        return (Void)operation.execute(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public Void transactWriteItems(Consumer<TransactWriteItemsEnhancedRequest.Builder> requestConsumer) {
        TransactWriteItemsEnhancedRequest.Builder builder = TransactWriteItemsEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.transactWriteItems(builder.build());
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    public MapperExtension mapperExtension() {
        return this.mapperExtension;
    }

    public Builder toBuilder() {
        return DefaultDynamoDbEnhancedClient.builder().dynamoDbClient(this.dynamoDbClient).extendWith(this.mapperExtension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbEnhancedClient that = (DefaultDynamoDbEnhancedClient)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        return this.mapperExtension != null ? this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        return result;
    }

    public static final class Builder
    implements DynamoDbEnhancedClient.Builder {
        private DynamoDbClient dynamoDbClient;
        private MapperExtension mapperExtension;

        @Override
        public DefaultDynamoDbEnhancedClient build() {
            if (this.dynamoDbClient == null) {
                throw new IllegalArgumentException("You must provide a DynamoDbClient to build a DefaultDynamoDbEnhancedClient.");
            }
            return new DefaultDynamoDbEnhancedClient(this.dynamoDbClient, this.mapperExtension);
        }

        @Override
        public Builder dynamoDbClient(DynamoDbClient dynamoDbClient) {
            this.dynamoDbClient = dynamoDbClient;
            return this;
        }

        @Override
        public Builder extendWith(MapperExtension mapperExtension) {
            if (mapperExtension != null && this.mapperExtension != null) {
                throw new IllegalArgumentException("You may only extend a DefaultDynamoDbEnhancedClient with a single extension. To combine multiple extensions, use the ChainMapperExtension.");
            }
            this.mapperExtension = mapperExtension;
            return this;
        }
    }
}

