/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkInternalApi
public class DeleteItemOperation<T>
implements TableOperation<T, DeleteItemRequest, DeleteItemResponse, T>,
TransactableWriteOperation<T>,
BatchableWriteOperation<T> {
    private final DeleteItemEnhancedRequest request;

    private DeleteItemOperation(DeleteItemEnhancedRequest request) {
        this.request = request;
    }

    public static <T> DeleteItemOperation<T> create(DeleteItemEnhancedRequest request) {
        return new DeleteItemOperation<T>(request);
    }

    @Override
    public DeleteItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("DeleteItem cannot be executed against a secondary index.");
        }
        DeleteItemRequest.Builder requestBuilder = DeleteItemRequest.builder().tableName(operationContext.tableName()).key(this.request.key().keyMap(tableSchema, operationContext.indexName())).returnValues(ReturnValue.ALL_OLD);
        requestBuilder = this.addExpressionsIfExist(requestBuilder);
        return (DeleteItemRequest)requestBuilder.build();
    }

    @Override
    public T transformResponse(DeleteItemResponse response, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return Utils.readAndTransformSingleItem(response.attributes(), tableSchema, operationContext, mapperExtension);
    }

    @Override
    public Function<DeleteItemRequest, DeleteItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).deleteItem(arg_0);
    }

    @Override
    public Function<DeleteItemRequest, CompletableFuture<DeleteItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).deleteItem(arg_0);
    }

    @Override
    public WriteRequest generateWriteRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        DeleteItemRequest deleteItemRequest = this.generateRequest(tableSchema, operationContext, mapperExtension);
        return (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(deleteItemRequest.key()).build()).build();
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        DeleteItemRequest deleteItemRequest = this.generateRequest(tableSchema, operationContext, mapperExtension);
        Delete delete = (Delete)Delete.builder().key(deleteItemRequest.key()).tableName(deleteItemRequest.tableName()).conditionExpression(deleteItemRequest.conditionExpression()).expressionAttributeValues(deleteItemRequest.expressionAttributeValues()).expressionAttributeNames(deleteItemRequest.expressionAttributeNames()).build();
        return (TransactWriteItem)TransactWriteItem.builder().delete(delete).build();
    }

    private DeleteItemRequest.Builder addExpressionsIfExist(DeleteItemRequest.Builder requestBuilder) {
        if (this.request.conditionExpression() != null) {
            requestBuilder = requestBuilder.conditionExpression(this.request.conditionExpression().expression());
            if (!this.request.conditionExpression().expressionNames().isEmpty()) {
                requestBuilder = requestBuilder.expressionAttributeNames(this.request.conditionExpression().expressionNames());
            }
            if (!this.request.conditionExpression().expressionValues().isEmpty()) {
                requestBuilder = requestBuilder.expressionAttributeValues(this.request.conditionExpression().expressionValues());
            }
        }
        return requestBuilder;
    }
}

