/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchWriteItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchWriteResult;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public class BatchWriteItemOperation
implements DatabaseOperation<BatchWriteItemRequest, BatchWriteItemResponse, BatchWriteResult> {
    private final BatchWriteItemEnhancedRequest request;

    private BatchWriteItemOperation(BatchWriteItemEnhancedRequest request) {
        this.request = request;
    }

    public static BatchWriteItemOperation create(BatchWriteItemEnhancedRequest request) {
        return new BatchWriteItemOperation(request);
    }

    @Override
    public BatchWriteItemRequest generateRequest(MapperExtension mapperExtension) {
        HashMap allRequestItems = new HashMap();
        this.request.writeBatches().forEach(writeBatch -> {
            Collection writeRequestsForTable = allRequestItems.computeIfAbsent(writeBatch.tableName(), ignored -> new ArrayList());
            writeRequestsForTable.addAll(writeBatch.writeRequests());
        });
        return (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(Collections.unmodifiableMap(CollectionUtils.deepCopyMap(allRequestItems))).build();
    }

    @Override
    public BatchWriteResult transformResponse(BatchWriteItemResponse response, MapperExtension mapperExtension) {
        return BatchWriteResult.builder().unprocessedRequests(response.unprocessedItems()).build();
    }

    @Override
    public Function<BatchWriteItemRequest, BatchWriteItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).batchWriteItem(arg_0);
    }

    @Override
    public Function<BatchWriteItemRequest, CompletableFuture<BatchWriteItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).batchWriteItem(arg_0);
    }
}

