/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.WriteBatch;

@SdkPublicApi
public final class BatchWriteItemEnhancedRequest {
    private final List<WriteBatch> writeBatches;

    private BatchWriteItemEnhancedRequest(Builder builder) {
        this.writeBatches = Collections.unmodifiableList(builder.writeBatches);
    }

    public static BatchWriteItemEnhancedRequest create(Collection<WriteBatch> writeBatches) {
        return BatchWriteItemEnhancedRequest.builder().writeBatches(writeBatches).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().writeBatches(this.writeBatches);
    }

    public Collection<WriteBatch> writeBatches() {
        return this.writeBatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchWriteItemEnhancedRequest that = (BatchWriteItemEnhancedRequest)o;
        return this.writeBatches != null ? this.writeBatches.equals(that.writeBatches) : that.writeBatches == null;
    }

    public int hashCode() {
        return this.writeBatches != null ? this.writeBatches.hashCode() : 0;
    }

    public static final class Builder {
        private List<WriteBatch> writeBatches;

        private Builder() {
        }

        public Builder writeBatches(Collection<WriteBatch> writeBatches) {
            this.writeBatches = new ArrayList<WriteBatch>(writeBatches);
            return this;
        }

        public Builder writeBatches(WriteBatch ... writeBatches) {
            this.writeBatches = Arrays.asList(writeBatches);
            return this;
        }

        public Builder addWriteBatch(WriteBatch writeBatch) {
            if (this.writeBatches == null) {
                this.writeBatches = new ArrayList<WriteBatch>();
            }
            this.writeBatches.add(writeBatch);
            return this;
        }

        public BatchWriteItemEnhancedRequest build() {
            return new BatchWriteItemEnhancedRequest(this);
        }
    }
}

