/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;

@SdkPublicApi
public final class DeleteItemEnhancedRequest<T> {
    private final Key key;
    private final Expression conditionExpression;

    private DeleteItemEnhancedRequest(Builder builder) {
        this.key = builder.key;
        this.conditionExpression = builder.conditionExpression;
    }

    public static <T> DeleteItemEnhancedRequest<T> create(Key key) {
        return DeleteItemEnhancedRequest.builder().key(key).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DeleteItemEnhancedRequest.builder().key(this.key).conditionExpression(this.conditionExpression);
    }

    public Key key() {
        return this.key;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteItemEnhancedRequest that = (DeleteItemEnhancedRequest)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public static final class Builder {
        private Key key;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public <T> DeleteItemEnhancedRequest<T> build() {
            return new DeleteItemEnhancedRequest(this);
        }
    }
}

