/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformPublisher;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
public interface PaginatedDatabaseOperation<RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(MapperExtension var1);

    public Function<RequestT, SdkIterable<ResponseT>> serviceCall(DynamoDbClient var1);

    public Function<RequestT, SdkPublisher<ResponseT>> asyncServiceCall(DynamoDbAsyncClient var1);

    public ResultT transformResponse(ResponseT var1, MapperExtension var2);

    default public SdkIterable<ResultT> execute(DynamoDbClient dynamoDbClient, MapperExtension mapperExtension) {
        RequestT request = this.generateRequest(mapperExtension);
        SdkIterable<ResponseT> response = this.serviceCall(dynamoDbClient).apply(request);
        return TransformIterable.of(response, r -> this.transformResponse(r, mapperExtension));
    }

    default public SdkPublisher<ResultT> executeAsync(DynamoDbAsyncClient dynamoDbAsyncClient, MapperExtension mapperExtension) {
        RequestT request = this.generateRequest(mapperExtension);
        SdkPublisher<ResponseT> response = this.asyncServiceCall(dynamoDbAsyncClient).apply(request);
        return TransformPublisher.of(response, r -> this.transformResponse(r, mapperExtension));
    }
}

