/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableReadOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;

@SdkPublicApi
public class ReadTransaction<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final TransactableReadOperation<T> readOperation;

    private ReadTransaction(Builder<T> builder) {
        this.mappedTableResource = ((Builder)builder).mappedTableResource;
        this.readOperation = ((Builder)builder).readOperation;
    }

    public static <T> ReadTransaction<T> create(MappedTableResource<T> mappedTableResource, TransactableReadOperation<T> readOperation) {
        return new Builder<T>().mappedTableResource(mappedTableResource).readOperation(readOperation).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().mappedTableResource(this.mappedTableResource).readOperation(this.readOperation);
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public TransactableReadOperation<T> readOperation() {
        return this.readOperation;
    }

    public TransactGetItem generateTransactGetItem() {
        return this.readOperation.generateTransactGetItem(this.mappedTableResource.tableSchema(), OperationContext.create(this.mappedTableResource.tableName()), this.mappedTableResource.mapperExtension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadTransaction that = (ReadTransaction)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(that.mappedTableResource) : that.mappedTableResource != null) {
            return false;
        }
        return this.readOperation != null ? this.readOperation.equals(that.readOperation) : that.readOperation == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.readOperation != null ? this.readOperation.hashCode() : 0);
        return result;
    }

    public static final class Builder<T> {
        private MappedTableResource<T> mappedTableResource;
        private TransactableReadOperation<T> readOperation;

        private Builder() {
        }

        public Builder<T> mappedTableResource(MappedTableResource<T> mappedTableResource) {
            this.mappedTableResource = mappedTableResource;
            return this;
        }

        public Builder<T> readOperation(TransactableReadOperation<T> readOperation) {
            this.readOperation = readOperation;
            return this;
        }

        public ReadTransaction<T> build() {
            return new ReadTransaction(this);
        }
    }
}

