/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public class WriteBatch<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final List<BatchableWriteOperation<T>> writeOperations;

    private WriteBatch(Builder<T> builder) {
        this.mappedTableResource = ((Builder)builder).mappedTableResource;
        this.writeOperations = Collections.unmodifiableList(((Builder)builder).writeOperations);
    }

    public static <T> WriteBatch<T> create(MappedTableResource<T> mappedTableResource, Collection<BatchableWriteOperation<T>> writeOperations) {
        return new Builder<T>().mappedTableResource(mappedTableResource).writeOperations(writeOperations).build();
    }

    @SafeVarargs
    public static <T> WriteBatch<T> create(MappedTableResource<T> mappedTableResource, BatchableWriteOperation<T> ... writeOperations) {
        return new Builder<T>().mappedTableResource(mappedTableResource).writeOperations(writeOperations).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().mappedTableResource(this.mappedTableResource).writeOperations(this.writeOperations);
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public Collection<BatchableWriteOperation<T>> writeOperations() {
        return this.writeOperations;
    }

    public void addWriteRequestsToMap(Map<String, Collection<WriteRequest>> writeRequestMap) {
        Collection writeRequestsForTable = writeRequestMap.computeIfAbsent(this.mappedTableResource.tableName(), ignored -> new ArrayList());
        writeRequestsForTable.addAll(this.writeOperations.stream().map(operation -> operation.generateWriteRequest(this.mappedTableResource.tableSchema(), OperationContext.create(this.mappedTableResource.tableName()), this.mappedTableResource.mapperExtension())).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteBatch that = (WriteBatch)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(that.mappedTableResource) : that.mappedTableResource != null) {
            return false;
        }
        return this.writeOperations != null ? this.writeOperations.equals(that.writeOperations) : that.writeOperations == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.writeOperations != null ? this.writeOperations.hashCode() : 0);
        return result;
    }

    public static final class Builder<T> {
        private MappedTableResource<T> mappedTableResource;
        private List<BatchableWriteOperation<T>> writeOperations;

        private Builder() {
        }

        public Builder<T> mappedTableResource(MappedTableResource<T> mappedTableResource) {
            this.mappedTableResource = mappedTableResource;
            return this;
        }

        public Builder<T> writeOperations(Collection<BatchableWriteOperation<T>> writeOperations) {
            this.writeOperations = new ArrayList<BatchableWriteOperation<T>>(writeOperations);
            return this;
        }

        public Builder<T> writeOperations(BatchableWriteOperation<T> ... writeOperations) {
            this.writeOperations = Arrays.asList(writeOperations);
            return this;
        }

        public Builder addWriteOperation(BatchableWriteOperation<T> writeOperation) {
            if (this.writeOperations == null) {
                this.writeOperations = new ArrayList<BatchableWriteOperation<T>>();
            }
            this.writeOperations.add(writeOperation);
            return this;
        }

        public WriteBatch<T> build() {
            return new WriteBatch(this);
        }
    }
}

