/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.WriteTransaction;

@SdkPublicApi
public class TransactWriteItemsEnhancedRequest {
    private final List<WriteTransaction> writeTransactions;

    private TransactWriteItemsEnhancedRequest(Builder builder) {
        this.writeTransactions = Collections.unmodifiableList(builder.writeTransactions);
    }

    public static TransactWriteItemsEnhancedRequest create(Collection<WriteTransaction> writeTransactions) {
        return TransactWriteItemsEnhancedRequest.builder().writeTransactions(writeTransactions).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().writeTransactions(this.writeTransactions);
    }

    public List<WriteTransaction> writeTransactions() {
        return this.writeTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactWriteItemsEnhancedRequest that = (TransactWriteItemsEnhancedRequest)o;
        return this.writeTransactions != null ? this.writeTransactions.equals(that.writeTransactions) : that.writeTransactions == null;
    }

    public int hashCode() {
        return this.writeTransactions != null ? this.writeTransactions.hashCode() : 0;
    }

    public static final class Builder {
        private List<WriteTransaction> writeTransactions;

        private Builder() {
        }

        public Builder writeTransactions(Collection<WriteTransaction> writeTransactions) {
            this.writeTransactions = new ArrayList<WriteTransaction>(writeTransactions);
            return this;
        }

        public Builder writeTransactions(WriteTransaction ... writeTransactions) {
            this.writeTransactions = Arrays.asList(writeTransactions);
            return this;
        }

        public Builder addWriteBatch(WriteTransaction writeTransaction) {
            if (this.writeTransactions == null) {
                this.writeTransactions = new ArrayList<WriteTransaction>();
            }
            this.writeTransactions.add(writeTransaction);
            return this;
        }

        public TransactWriteItemsEnhancedRequest build() {
            return new TransactWriteItemsEnhancedRequest(this);
        }
    }
}

