/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformPublisher;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
public interface PaginatedOperation<ItemT, RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(TableSchema<ItemT> var1, OperationContext var2, MapperExtension var3);

    public Function<RequestT, SdkIterable<ResponseT>> serviceCall(DynamoDbClient var1);

    public Function<RequestT, SdkPublisher<ResponseT>> asyncServiceCall(DynamoDbAsyncClient var1);

    public ResultT transformResponse(ResponseT var1, TableSchema<ItemT> var2, OperationContext var3, MapperExtension var4);

    default public SdkIterable<ResultT> execute(TableSchema<ItemT> tableSchema, OperationContext context, MapperExtension mapperExtension, DynamoDbClient dynamoDbClient) {
        RequestT request = this.generateRequest(tableSchema, context, mapperExtension);
        SdkIterable<ResponseT> response = this.serviceCall(dynamoDbClient).apply(request);
        return TransformIterable.of(response, r -> this.transformResponse(r, tableSchema, context, mapperExtension));
    }

    default public SdkPublisher<ResultT> executeAsync(TableSchema<ItemT> tableSchema, OperationContext context, MapperExtension mapperExtension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        RequestT request = this.generateRequest(tableSchema, context, mapperExtension);
        SdkPublisher<ResponseT> response = this.asyncServiceCall(dynamoDbAsyncClient).apply(request);
        return TransformPublisher.of(response, r -> this.transformResponse(r, tableSchema, context, mapperExtension));
    }
}

