/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.CommonOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
public interface TableOperation<ItemT, RequestT, ResponseT, ResultT>
extends CommonOperation<ItemT, RequestT, ResponseT, ResultT> {
    default public ResultT executeOnPrimaryIndex(TableSchema<ItemT> tableSchema, String tableName, MapperExtension mapperExtension, DynamoDbClient dynamoDbClient) {
        OperationContext context = OperationContext.create(tableName, TableMetadata.primaryIndexName());
        return this.execute(tableSchema, context, mapperExtension, dynamoDbClient);
    }

    default public CompletableFuture<ResultT> executeOnPrimaryIndexAsync(TableSchema<ItemT> tableSchema, String tableName, MapperExtension mapperExtension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        OperationContext context = OperationContext.create(tableName, TableMetadata.primaryIndexName());
        return this.executeAsync(tableSchema, context, mapperExtension, dynamoDbAsyncClient);
    }
}

