/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;

@SdkInternalApi
public class TransformPublisher<T, R>
implements SdkPublisher<R> {
    private final SdkPublisher<T> wrappedPublisher;
    private final Function<T, R> transformFunction;

    private TransformPublisher(SdkPublisher<T> wrappedPublisher, Function<T, R> transformFunction) {
        this.wrappedPublisher = wrappedPublisher;
        this.transformFunction = transformFunction;
    }

    public static <T, R> TransformPublisher<T, R> of(SdkPublisher<T> publisher, Function<T, R> transformFunction) {
        return new TransformPublisher<T, R>(publisher, transformFunction);
    }

    public void subscribe(Subscriber<? super R> subscriber) {
        this.wrappedPublisher.subscribe((Subscriber)new TransformSubscriber(subscriber));
    }

    private final class TransformSubscriber
    implements Subscriber<T> {
        private final Subscriber<? super R> delegateSubscriber;

        private TransformSubscriber(Subscriber<? super R> delegateSubscriber) {
            this.delegateSubscriber = delegateSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.delegateSubscriber.onSubscribe(subscription);
        }

        public void onNext(T t) {
            this.delegateSubscriber.onNext(TransformPublisher.this.transformFunction.apply(t));
        }

        public void onError(Throwable throwable) {
            this.delegateSubscriber.onError(throwable);
        }

        public void onComplete() {
            this.delegateSubscriber.onComplete();
        }
    }
}

