/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Page;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.PaginatedIndexOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.PaginatedTableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

@SdkPublicApi
public class Scan<T>
implements PaginatedTableOperation<T, ScanRequest, ScanResponse, Page<T>>,
PaginatedIndexOperation<T, ScanRequest, ScanResponse, Page<T>> {
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;

    private Scan(Map<String, AttributeValue> exclusiveStartKey, Integer limit, Boolean consistentRead, Expression filterExpression) {
        this.exclusiveStartKey = exclusiveStartKey;
        this.limit = limit;
        this.consistentRead = consistentRead;
        this.filterExpression = filterExpression;
    }

    public static <T> Scan<T> create() {
        return new Scan<T>(null, null, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().exclusiveStartKey(this.exclusiveStartKey).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression);
    }

    @Override
    public ScanRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        ScanRequest.Builder scanRequest = ScanRequest.builder().tableName(operationContext.tableName()).limit(this.limit).exclusiveStartKey(this.exclusiveStartKey).consistentRead(this.consistentRead);
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            scanRequest = scanRequest.indexName(operationContext.indexName());
        }
        if (this.filterExpression != null) {
            scanRequest = scanRequest.filterExpression(this.filterExpression.expression()).expressionAttributeValues(this.filterExpression.expressionValues()).expressionAttributeNames(this.filterExpression.expressionNames());
        }
        return (ScanRequest)scanRequest.build();
    }

    @Override
    public Page<T> transformResponse(ScanResponse response, TableSchema<T> tableSchema, OperationContext context, MapperExtension mapperExtension) {
        return Utils.readAndTransformPaginatedItems(response, tableSchema, context, mapperExtension, ScanResponse::items, ScanResponse::lastEvaluatedKey);
    }

    @Override
    public Function<ScanRequest, SdkIterable<ScanResponse>> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).scanPaginator(arg_0);
    }

    @Override
    public Function<ScanRequest, SdkPublisher<ScanResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).scanPaginator(arg_0);
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Expression filterExpression() {
        return this.filterExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scan scan = (Scan)o;
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(scan.exclusiveStartKey) : scan.exclusiveStartKey != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(scan.limit) : scan.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(scan.consistentRead) : scan.consistentRead != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(scan.filterExpression) : scan.filterExpression == null;
    }

    public int hashCode() {
        int result = this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0;
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Map<String, AttributeValue> exclusiveStartKey;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;

        private Builder() {
        }

        public <T> Scan<T> build() {
            return new Scan(this.exclusiveStartKey, this.limit, this.consistentRead, this.filterExpression);
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = exclusiveStartKey;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }
    }
}

