/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableReadOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

@SdkPublicApi
public class ReadBatch<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final Collection<BatchableReadOperation> readOperations;

    private ReadBatch(MappedTableResource<T> mappedTableResource, Collection<BatchableReadOperation> readOperations) {
        this.mappedTableResource = mappedTableResource;
        this.readOperations = readOperations;
    }

    public static <T> ReadBatch<T> of(MappedTableResource<T> mappedTableResource, Collection<BatchableReadOperation> readOperations) {
        return new ReadBatch<T>(mappedTableResource, readOperations);
    }

    public static <T> ReadBatch<T> of(MappedTableResource<T> mappedTableResource, BatchableReadOperation ... readOperations) {
        return new ReadBatch<T>(mappedTableResource, Arrays.asList(readOperations));
    }

    void addReadRequestsToMap(Map<String, KeysAndAttributes> readRequestMap) {
        KeysAndAttributes newKeysAndAttributes = this.generateKeysAndAttributes();
        KeysAndAttributes existingKeysAndAttributes = readRequestMap.get(this.tableName());
        if (existingKeysAndAttributes == null) {
            readRequestMap.put(this.tableName(), newKeysAndAttributes);
            return;
        }
        KeysAndAttributes mergedKeysAndAttributes = ReadBatch.mergeKeysAndAttributes(existingKeysAndAttributes, newKeysAndAttributes);
        readRequestMap.put(this.tableName(), mergedKeysAndAttributes);
    }

    String tableName() {
        return this.mappedTableResource.tableName();
    }

    private KeysAndAttributes generateKeysAndAttributes() {
        AtomicReference consistentRead = new AtomicReference();
        AtomicBoolean firstRecord = new AtomicBoolean(true);
        List keys = this.readOperations.stream().peek(operation -> {
            if (firstRecord.getAndSet(false)) {
                consistentRead.set(operation.consistentRead());
            } else if (!ReadBatch.compareNullableBooleans((Boolean)consistentRead.get(), operation.consistentRead())) {
                throw new IllegalArgumentException("All batchable read requests for the same table must have the same 'consistentRead' setting.");
            }
        }).map(BatchableReadOperation::key).map(key -> key.keyMap(this.mappedTableResource.tableSchema(), TableMetadata.primaryIndexName())).collect(Collectors.toList());
        return (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).consistentRead((Boolean)consistentRead.get()).build();
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public Collection<BatchableReadOperation> readOperations() {
        return this.readOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadBatch readBatch = (ReadBatch)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(readBatch.mappedTableResource) : readBatch.mappedTableResource != null) {
            return false;
        }
        return this.readOperations != null ? this.readOperations.equals(readBatch.readOperations) : readBatch.readOperations == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.readOperations != null ? this.readOperations.hashCode() : 0);
        return result;
    }

    private static boolean compareNullableBooleans(Boolean one, Boolean two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null) {
            return one.equals(two);
        }
        return false;
    }

    private static KeysAndAttributes mergeKeysAndAttributes(KeysAndAttributes first, KeysAndAttributes second) {
        if (!ReadBatch.compareNullableBooleans(first.consistentRead(), second.consistentRead())) {
            throw new IllegalArgumentException("All batchable read requests for the same table must have the same 'consistentRead' setting.");
        }
        Boolean consistentRead = first.consistentRead() == null ? second.consistentRead() : first.consistentRead();
        List keys = Stream.concat(first.keys().stream(), second.keys().stream()).collect(Collectors.toList());
        return (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).consistentRead(consistentRead).build();
    }
}

