/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Page;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.PaginatedIndexOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.PaginatedTableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.QueryConditional;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

@SdkPublicApi
public class Query<T>
implements PaginatedTableOperation<T, QueryRequest, QueryResponse, Page<T>>,
PaginatedIndexOperation<T, QueryRequest, QueryResponse, Page<T>> {
    private final QueryConditional queryConditional;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Boolean scanIndexForward;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;

    private Query(QueryConditional queryConditional, Map<String, AttributeValue> exclusiveStartKey, Boolean scanIndexForward, Integer limit, Boolean consistentRead, Expression filterExpression) {
        this.queryConditional = queryConditional;
        this.exclusiveStartKey = exclusiveStartKey;
        this.scanIndexForward = scanIndexForward;
        this.limit = limit;
        this.consistentRead = consistentRead;
        this.filterExpression = filterExpression;
    }

    public static <T> Query<T> of(QueryConditional queryConditional) {
        return new Query<T>(queryConditional, null, null, null, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().queryConditional(this.queryConditional).exclusiveStartKey(this.exclusiveStartKey).scanIndexForward(this.scanIndexForward).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression);
    }

    @Override
    public QueryRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        Expression queryExpression = this.queryConditional.expression(tableSchema, operationContext.indexName());
        Map<String, AttributeValue> expressionValues = queryExpression.expressionValues();
        Map<String, String> expressionNames = queryExpression.expressionNames();
        if (this.filterExpression != null) {
            expressionValues = Expression.coalesceValues(expressionValues, this.filterExpression.expressionValues());
            expressionNames = Expression.coalesceNames(expressionNames, this.filterExpression.expressionNames());
        }
        QueryRequest.Builder queryRequest = QueryRequest.builder().tableName(operationContext.tableName()).keyConditionExpression(queryExpression.expression()).expressionAttributeValues(expressionValues).expressionAttributeNames(expressionNames).scanIndexForward(this.scanIndexForward).limit(this.limit).exclusiveStartKey(this.exclusiveStartKey).consistentRead(this.consistentRead);
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            queryRequest = queryRequest.indexName(operationContext.indexName());
        }
        if (this.filterExpression != null) {
            queryRequest = queryRequest.filterExpression(this.filterExpression.expression());
        }
        return (QueryRequest)queryRequest.build();
    }

    @Override
    public Function<QueryRequest, SdkIterable<QueryResponse>> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).queryPaginator(arg_0);
    }

    @Override
    public Function<QueryRequest, SdkPublisher<QueryResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).queryPaginator(arg_0);
    }

    @Override
    public Page<T> transformResponse(QueryResponse response, TableSchema<T> tableSchema, OperationContext context, MapperExtension mapperExtension) {
        return Utils.readAndTransformPaginatedItems(response, tableSchema, context, mapperExtension, QueryResponse::items, QueryResponse::lastEvaluatedKey);
    }

    public QueryConditional queryConditional() {
        return this.queryConditional;
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Boolean scanIndexForward() {
        return this.scanIndexForward;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Expression filterExpression() {
        return this.filterExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.queryConditional != null ? !this.queryConditional.equals(query.queryConditional) : query.queryConditional != null) {
            return false;
        }
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(query.exclusiveStartKey) : query.exclusiveStartKey != null) {
            return false;
        }
        if (this.scanIndexForward != null ? !this.scanIndexForward.equals(query.scanIndexForward) : query.scanIndexForward != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(query.limit) : query.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(query.consistentRead) : query.consistentRead != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(query.filterExpression) : query.filterExpression == null;
    }

    public int hashCode() {
        int result = this.queryConditional != null ? this.queryConditional.hashCode() : 0;
        result = 31 * result + (this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0);
        result = 31 * result + (this.scanIndexForward != null ? this.scanIndexForward.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private QueryConditional queryConditional;
        private Map<String, AttributeValue> exclusiveStartKey;
        private Boolean scanIndexForward;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;

        private Builder() {
        }

        public <T> Query<T> build() {
            return new Query(this.queryConditional, this.exclusiveStartKey, this.scanIndexForward, this.limit, this.consistentRead, this.filterExpression);
        }

        public Builder queryConditional(QueryConditional queryConditional) {
            this.queryConditional = queryConditional;
            return this;
        }

        public Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = exclusiveStartKey;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }
    }
}

