/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableReadOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableReadOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.Get;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;

@SdkPublicApi
public class GetItem<T>
implements TableOperation<T, GetItemRequest, GetItemResponse, T>,
BatchableReadOperation,
TransactableReadOperation<T> {
    private final Key key;
    private final Boolean consistentRead;

    private GetItem(Key key, Boolean consistentRead) {
        this.key = key;
        this.consistentRead = consistentRead;
    }

    public static <T> GetItem<T> of(Key key) {
        return new GetItem<T>(key, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().key(this.key).consistentRead(this.consistentRead);
    }

    @Override
    public Boolean consistentRead() {
        return this.consistentRead;
    }

    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public GetItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext context, MapperExtension mapperExtension) {
        if (!TableMetadata.primaryIndexName().equals(context.indexName())) {
            throw new IllegalArgumentException("GetItem cannot be executed against a secondary index.");
        }
        return (GetItemRequest)GetItemRequest.builder().tableName(context.tableName()).key(this.key.keyMap(tableSchema, context.indexName())).consistentRead(this.consistentRead).build();
    }

    @Override
    public T transformResponse(GetItemResponse response, TableSchema<T> tableSchema, OperationContext context, MapperExtension mapperExtension) {
        return Utils.readAndTransformSingleItem(response.item(), tableSchema, context, mapperExtension);
    }

    @Override
    public Function<GetItemRequest, GetItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).getItem(arg_0);
    }

    @Override
    public Function<GetItemRequest, CompletableFuture<GetItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).getItem(arg_0);
    }

    @Override
    public TransactGetItem generateTransactGetItem(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return (TransactGetItem)TransactGetItem.builder().get((Get)Get.builder().tableName(operationContext.tableName()).key(this.key.keyMap(tableSchema, operationContext.indexName())).build()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetItem getItem = (GetItem)o;
        if (this.key != null ? !this.key.equals(getItem.key) : getItem.key != null) {
            return false;
        }
        return this.consistentRead != null ? this.consistentRead.equals(getItem.consistentRead) : getItem.consistentRead == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Key key;
        private Boolean consistentRead;

        private Builder() {
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public <T> GetItem<T> build() {
            return new GetItem(this.key, this.consistentRead);
        }
    }
}

