/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableReadOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;

@SdkPublicApi
public class ReadTransaction<T> {
    private final MappedTable<T> mappedTable;
    private final TransactableReadOperation<T> readOperation;

    private ReadTransaction(MappedTable<T> mappedTable, TransactableReadOperation<T> readOperation) {
        this.mappedTable = mappedTable;
        this.readOperation = readOperation;
    }

    public static <T> ReadTransaction<T> of(MappedTable<T> mappedTable, TransactableReadOperation<T> readOperation) {
        return new ReadTransaction<T>(mappedTable, readOperation);
    }

    public MappedTable<T> mappedTable() {
        return this.mappedTable;
    }

    public TransactableReadOperation<T> readOperation() {
        return this.readOperation;
    }

    TransactGetItem generateTransactGetItem() {
        return this.readOperation.generateTransactGetItem(this.mappedTable.tableSchema(), OperationContext.of(this.mappedTable.tableName()), this.mappedTable.mapperExtension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadTransaction that = (ReadTransaction)o;
        if (this.mappedTable != null ? !this.mappedTable.equals(that.mappedTable) : that.mappedTable != null) {
            return false;
        }
        return this.readOperation != null ? this.readOperation.equals(that.readOperation) : that.readOperation == null;
    }

    public int hashCode() {
        int result = this.mappedTable != null ? this.mappedTable.hashCode() : 0;
        result = 31 * result + (this.readOperation != null ? this.readOperation.hashCode() : 0);
        return result;
    }
}

