/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.AttributeValues;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.AttributeValueType;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions.WriteModification;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.staticmapper.AttributeTag;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public class VersionedRecordExtension
implements MapperExtension {
    private static final Function<String, String> EXPRESSION_KEY_MAPPER = key -> ":old_" + key + "_value";
    private static final String CUSTOM_METADATA_KEY = "VersionedRecordExtension:VersionAttribute";
    private static final VersionAttribute VERSION_ATTRIBUTE = new VersionAttribute();

    private VersionedRecordExtension() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public WriteModification beforeWrite(Map<String, AttributeValue> item, OperationContext operationContext, TableMetadata tableMetadata) {
        Expression condition;
        AttributeValue newVersionValue;
        Optional<String> versionAttributeKey = tableMetadata.customMetadataObject(CUSTOM_METADATA_KEY, String.class);
        if (!versionAttributeKey.isPresent()) {
            return WriteModification.builder().build();
        }
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(item);
        Optional existingVersionValue = Optional.ofNullable(itemToTransform.get(versionAttributeKey.get()));
        if (!existingVersionValue.isPresent() || AttributeValues.isNullAttributeValue((AttributeValue)existingVersionValue.get())) {
            newVersionValue = (AttributeValue)AttributeValue.builder().n("1").build();
            condition = Expression.builder().expression(String.format("attribute_not_exists(%s)", versionAttributeKey.get())).build();
        } else {
            if (((AttributeValue)existingVersionValue.get()).n() == null) {
                throw new IllegalArgumentException("Version attribute appears to be the wrong type. N is required.");
            }
            int existingVersion = Integer.parseInt(((AttributeValue)existingVersionValue.get()).n());
            String existingVersionValueKey = EXPRESSION_KEY_MAPPER.apply(versionAttributeKey.get());
            newVersionValue = (AttributeValue)AttributeValue.builder().n(Integer.toString(existingVersion + 1)).build();
            condition = Expression.builder().expression(String.format("%s = %s", versionAttributeKey.get(), existingVersionValueKey)).expressionValues(Collections.singletonMap(existingVersionValueKey, existingVersionValue.get())).build();
        }
        itemToTransform.put(versionAttributeKey.get(), newVersionValue);
        return WriteModification.builder().transformedItem(Collections.unmodifiableMap(itemToTransform)).additionalConditionalExpression(condition).build();
    }

    public static final class Builder {
        private Builder() {
        }

        public VersionedRecordExtension build() {
            return new VersionedRecordExtension();
        }
    }

    private static class VersionAttribute
    extends AttributeTag {
        private VersionAttribute() {
        }

        @Override
        protected boolean isKeyAttribute() {
            return true;
        }

        @Override
        public Map<String, Object> customMetadataForAttribute(String attributeName, AttributeValueType attributeValueType) {
            if (!AttributeValueType.N.equals((Object)attributeValueType)) {
                throw new IllegalArgumentException(String.format("Attribute '%s' of type %s is not a suitable type to be used as a version attribute. Only type 'N' is supported.", attributeName, attributeValueType.name()));
            }
            return Collections.singletonMap(VersionedRecordExtension.CUSTOM_METADATA_KEY, attributeName);
        }
    }

    public static final class AttributeTags {
        private AttributeTags() {
        }

        public static AttributeTag version() {
            return VERSION_ATTRIBUTE;
        }
    }
}

