/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedDatabase;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.DynamoDbMappedTable;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
@ThreadSafe
public class DynamoDbMappedDatabase
implements MappedDatabase {
    private final DynamoDbClient dynamoDbClient;
    private final MapperExtension mapperExtension;

    private DynamoDbMappedDatabase(DynamoDbClient dynamoDbClient, MapperExtension mapperExtension) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> T execute(DatabaseOperation<?, ?, T> operation) {
        return operation.execute(this.dynamoDbClient, this.mapperExtension);
    }

    public <T> DynamoDbMappedTable<T> table(String tableName, TableSchema<T> tableSchema) {
        return new DynamoDbMappedTable<T>(this.dynamoDbClient, this.mapperExtension, tableSchema, tableName);
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    public MapperExtension mapperExtension() {
        return this.mapperExtension;
    }

    public Builder toBuilder() {
        return DynamoDbMappedDatabase.builder().dynamoDbClient(this.dynamoDbClient).extendWith(this.mapperExtension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamoDbMappedDatabase that = (DynamoDbMappedDatabase)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        return this.mapperExtension != null ? this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private DynamoDbClient dynamoDbClient;
        private MapperExtension mapperExtension;

        public DynamoDbMappedDatabase build() {
            if (this.dynamoDbClient == null) {
                throw new IllegalArgumentException("You must provide a DynamoDbClient to build a DynamoDbMappedDatabase.");
            }
            return new DynamoDbMappedDatabase(this.dynamoDbClient, this.mapperExtension);
        }

        public Builder dynamoDbClient(DynamoDbClient dynamoDbClient) {
            this.dynamoDbClient = dynamoDbClient;
            return this;
        }

        public Builder extendWith(MapperExtension mapperExtension) {
            if (mapperExtension != null && this.mapperExtension != null) {
                throw new IllegalArgumentException("You may only extend a DynamoDbMappedDatabase with a single extension. To combine multiple extensions, use the ChainMapperExtension.");
            }
            this.mapperExtension = mapperExtension;
            return this;
        }
    }
}

