/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;

@SdkPublicApi
public class ConditionCheck<T>
implements TransactableWriteOperation<T> {
    private final Key key;
    private final Expression conditionExpression;

    private ConditionCheck(Key key, Expression conditionExpression) {
        this.key = key;
        this.conditionExpression = conditionExpression;
    }

    public static <T> ConditionCheck<T> of(Key key, Expression conditionExpression) {
        return new ConditionCheck<T>(key, conditionExpression);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().key(this.key).conditionExpression(this.conditionExpression);
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        software.amazon.awssdk.services.dynamodb.model.ConditionCheck conditionCheck = (software.amazon.awssdk.services.dynamodb.model.ConditionCheck)software.amazon.awssdk.services.dynamodb.model.ConditionCheck.builder().tableName(operationContext.getTableName()).key(this.key.getKeyMap(tableSchema, operationContext.getIndexName())).conditionExpression(this.conditionExpression.getExpression()).expressionAttributeNames(this.conditionExpression.getExpressionNames()).expressionAttributeValues(this.conditionExpression.getExpressionValues()).build();
        return (TransactWriteItem)TransactWriteItem.builder().conditionCheck(conditionCheck).build();
    }

    public Key getKey() {
        return this.key;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionCheck that = (ConditionCheck)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return this.conditionExpression != null ? this.conditionExpression.equals(that.conditionExpression) : that.conditionExpression == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Key key;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public <T> ConditionCheck<T> build() {
            return new ConditionCheck(this.key, this.conditionExpression);
        }
    }
}

