/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dsql.model.ClusterStatus;
import software.amazon.awssdk.services.dsql.model.DsqlResponse;
import software.amazon.awssdk.services.dsql.model.EncryptionDetails;
import software.amazon.awssdk.services.dsql.model.MultiRegionProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterResponse
extends DsqlResponse
implements ToCopyableBuilder<Builder, CreateClusterResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(CreateClusterResponse.getter(CreateClusterResponse::identifier)).setter(CreateClusterResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateClusterResponse.getter(CreateClusterResponse::arn)).setter(CreateClusterResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateClusterResponse.getter(CreateClusterResponse::statusAsString)).setter(CreateClusterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CreateClusterResponse.getter(CreateClusterResponse::creationTime)).setter(CreateClusterResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<MultiRegionProperties> MULTI_REGION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("multiRegionProperties").getter(CreateClusterResponse.getter(CreateClusterResponse::multiRegionProperties)).setter(CreateClusterResponse.setter(Builder::multiRegionProperties)).constructor(MultiRegionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiRegionProperties").build()}).build();
    private static final SdkField<EncryptionDetails> ENCRYPTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionDetails").getter(CreateClusterResponse.getter(CreateClusterResponse::encryptionDetails)).setter(CreateClusterResponse.setter(Builder::encryptionDetails)).constructor(EncryptionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDetails").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtectionEnabled").getter(CreateClusterResponse.getter(CreateClusterResponse::deletionProtectionEnabled)).setter(CreateClusterResponse.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtectionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, MULTI_REGION_PROPERTIES_FIELD, ENCRYPTION_DETAILS_FIELD, DELETION_PROTECTION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateClusterResponse.memberNameToFieldInitializer();
    private final String identifier;
    private final String arn;
    private final String status;
    private final Instant creationTime;
    private final MultiRegionProperties multiRegionProperties;
    private final EncryptionDetails encryptionDetails;
    private final Boolean deletionProtectionEnabled;

    private CreateClusterResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.arn = builder.arn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.multiRegionProperties = builder.multiRegionProperties;
        this.encryptionDetails = builder.encryptionDetails;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String arn() {
        return this.arn;
    }

    public final ClusterStatus status() {
        return ClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final MultiRegionProperties multiRegionProperties() {
        return this.multiRegionProperties;
    }

    public final EncryptionDetails encryptionDetails() {
        return this.encryptionDetails;
    }

    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterResponse)) {
            return false;
        }
        CreateClusterResponse other = (CreateClusterResponse)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.multiRegionProperties(), other.multiRegionProperties()) && Objects.equals(this.encryptionDetails(), other.encryptionDetails()) && Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterResponse").add("Identifier", (Object)this.identifier()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("MultiRegionProperties", (Object)this.multiRegionProperties()).add("EncryptionDetails", (Object)this.encryptionDetails()).add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "multiRegionProperties": {
                return Optional.ofNullable(clazz.cast(this.multiRegionProperties()));
            }
            case "encryptionDetails": {
                return Optional.ofNullable(clazz.cast(this.encryptionDetails()));
            }
            case "deletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("multiRegionProperties", MULTI_REGION_PROPERTIES_FIELD);
        map.put("encryptionDetails", ENCRYPTION_DETAILS_FIELD);
        map.put("deletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterResponse, T> g) {
        return obj -> g.apply((CreateClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlResponse.BuilderImpl
    implements Builder {
        private String identifier;
        private String arn;
        private String status;
        private Instant creationTime;
        private MultiRegionProperties multiRegionProperties;
        private EncryptionDetails encryptionDetails;
        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterResponse model) {
            super(model);
            this.identifier(model.identifier);
            this.arn(model.arn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.multiRegionProperties(model.multiRegionProperties);
            this.encryptionDetails(model.encryptionDetails);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final MultiRegionProperties.Builder getMultiRegionProperties() {
            return this.multiRegionProperties != null ? this.multiRegionProperties.toBuilder() : null;
        }

        public final void setMultiRegionProperties(MultiRegionProperties.BuilderImpl multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties != null ? multiRegionProperties.build() : null;
        }

        @Override
        public final Builder multiRegionProperties(MultiRegionProperties multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties;
            return this;
        }

        public final EncryptionDetails.Builder getEncryptionDetails() {
            return this.encryptionDetails != null ? this.encryptionDetails.toBuilder() : null;
        }

        public final void setEncryptionDetails(EncryptionDetails.BuilderImpl encryptionDetails) {
            this.encryptionDetails = encryptionDetails != null ? encryptionDetails.build() : null;
        }

        @Override
        public final Builder encryptionDetails(EncryptionDetails encryptionDetails) {
            this.encryptionDetails = encryptionDetails;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public CreateClusterResponse build() {
            return new CreateClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DsqlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterResponse> {
        public Builder identifier(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(ClusterStatus var1);

        public Builder creationTime(Instant var1);

        public Builder multiRegionProperties(MultiRegionProperties var1);

        default public Builder multiRegionProperties(Consumer<MultiRegionProperties.Builder> multiRegionProperties) {
            return this.multiRegionProperties((MultiRegionProperties)((MultiRegionProperties.Builder)MultiRegionProperties.builder().applyMutation(multiRegionProperties)).build());
        }

        public Builder encryptionDetails(EncryptionDetails var1);

        default public Builder encryptionDetails(Consumer<EncryptionDetails.Builder> encryptionDetails) {
            return this.encryptionDetails((EncryptionDetails)((EncryptionDetails.Builder)EncryptionDetails.builder().applyMutation(encryptionDetails)).build());
        }

        public Builder deletionProtectionEnabled(Boolean var1);
    }
}

