/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dsql.model.ClusterPropertyMapCopier;
import software.amazon.awssdk.services.dsql.model.DsqlRequest;
import software.amazon.awssdk.services.dsql.model.LinkedClusterProperties;
import software.amazon.awssdk.services.dsql.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMultiRegionClustersRequest
extends DsqlRequest
implements ToCopyableBuilder<Builder, CreateMultiRegionClustersRequest> {
    private static final SdkField<List<String>> LINKED_REGION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("linkedRegionList").getter(CreateMultiRegionClustersRequest.getter(CreateMultiRegionClustersRequest::linkedRegionList)).setter(CreateMultiRegionClustersRequest.setter(Builder::linkedRegionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedRegionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, LinkedClusterProperties>> CLUSTER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("clusterProperties").getter(CreateMultiRegionClustersRequest.getter(CreateMultiRegionClustersRequest::clusterProperties)).setter(CreateMultiRegionClustersRequest.setter(Builder::clusterProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LinkedClusterProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WITNESS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("witnessRegion").getter(CreateMultiRegionClustersRequest.getter(CreateMultiRegionClustersRequest::witnessRegion)).setter(CreateMultiRegionClustersRequest.setter(Builder::witnessRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("witnessRegion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMultiRegionClustersRequest.getter(CreateMultiRegionClustersRequest::clientToken)).setter(CreateMultiRegionClustersRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_REGION_LIST_FIELD, CLUSTER_PROPERTIES_FIELD, WITNESS_REGION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMultiRegionClustersRequest.memberNameToFieldInitializer();
    private final List<String> linkedRegionList;
    private final Map<String, LinkedClusterProperties> clusterProperties;
    private final String witnessRegion;
    private final String clientToken;

    private CreateMultiRegionClustersRequest(BuilderImpl builder) {
        super(builder);
        this.linkedRegionList = builder.linkedRegionList;
        this.clusterProperties = builder.clusterProperties;
        this.witnessRegion = builder.witnessRegion;
        this.clientToken = builder.clientToken;
    }

    public final boolean hasLinkedRegionList() {
        return this.linkedRegionList != null && !(this.linkedRegionList instanceof SdkAutoConstructList);
    }

    public final List<String> linkedRegionList() {
        return this.linkedRegionList;
    }

    public final boolean hasClusterProperties() {
        return this.clusterProperties != null && !(this.clusterProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, LinkedClusterProperties> clusterProperties() {
        return this.clusterProperties;
    }

    public final String witnessRegion() {
        return this.witnessRegion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedRegionList() ? this.linkedRegionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterProperties() ? this.clusterProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.witnessRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionClustersRequest)) {
            return false;
        }
        CreateMultiRegionClustersRequest other = (CreateMultiRegionClustersRequest)((Object)obj);
        return this.hasLinkedRegionList() == other.hasLinkedRegionList() && Objects.equals(this.linkedRegionList(), other.linkedRegionList()) && this.hasClusterProperties() == other.hasClusterProperties() && Objects.equals(this.clusterProperties(), other.clusterProperties()) && Objects.equals(this.witnessRegion(), other.witnessRegion()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMultiRegionClustersRequest").add("LinkedRegionList", this.hasLinkedRegionList() ? this.linkedRegionList() : null).add("ClusterProperties", this.hasClusterProperties() ? this.clusterProperties() : null).add("WitnessRegion", (Object)this.witnessRegion()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "linkedRegionList": {
                return Optional.ofNullable(clazz.cast(this.linkedRegionList()));
            }
            case "clusterProperties": {
                return Optional.ofNullable(clazz.cast(this.clusterProperties()));
            }
            case "witnessRegion": {
                return Optional.ofNullable(clazz.cast(this.witnessRegion()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("linkedRegionList", LINKED_REGION_LIST_FIELD);
        map.put("clusterProperties", CLUSTER_PROPERTIES_FIELD);
        map.put("witnessRegion", WITNESS_REGION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionClustersRequest, T> g) {
        return obj -> g.apply((CreateMultiRegionClustersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlRequest.BuilderImpl
    implements Builder {
        private List<String> linkedRegionList = DefaultSdkAutoConstructList.getInstance();
        private Map<String, LinkedClusterProperties> clusterProperties = DefaultSdkAutoConstructMap.getInstance();
        private String witnessRegion;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionClustersRequest model) {
            super(model);
            this.linkedRegionList(model.linkedRegionList);
            this.clusterProperties(model.clusterProperties);
            this.witnessRegion(model.witnessRegion);
            this.clientToken(model.clientToken);
        }

        public final Collection<String> getLinkedRegionList() {
            if (this.linkedRegionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkedRegionList;
        }

        public final void setLinkedRegionList(Collection<String> linkedRegionList) {
            this.linkedRegionList = RegionListCopier.copy(linkedRegionList);
        }

        @Override
        public final Builder linkedRegionList(Collection<String> linkedRegionList) {
            this.linkedRegionList = RegionListCopier.copy(linkedRegionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedRegionList(String ... linkedRegionList) {
            this.linkedRegionList(Arrays.asList(linkedRegionList));
            return this;
        }

        public final Map<String, LinkedClusterProperties.Builder> getClusterProperties() {
            Map<String, LinkedClusterProperties.Builder> result = ClusterPropertyMapCopier.copyToBuilder(this.clusterProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setClusterProperties(Map<String, LinkedClusterProperties.BuilderImpl> clusterProperties) {
            this.clusterProperties = ClusterPropertyMapCopier.copyFromBuilder(clusterProperties);
        }

        @Override
        public final Builder clusterProperties(Map<String, LinkedClusterProperties> clusterProperties) {
            this.clusterProperties = ClusterPropertyMapCopier.copy(clusterProperties);
            return this;
        }

        public final String getWitnessRegion() {
            return this.witnessRegion;
        }

        public final void setWitnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
        }

        @Override
        public final Builder witnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiRegionClustersRequest build() {
            return new CreateMultiRegionClustersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DsqlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMultiRegionClustersRequest> {
        public Builder linkedRegionList(Collection<String> var1);

        public Builder linkedRegionList(String ... var1);

        public Builder clusterProperties(Map<String, LinkedClusterProperties> var1);

        public Builder witnessRegion(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

