/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceNetworkData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceNetworkData> {
    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceNetworkID").getter(SourceNetworkData.getter(SourceNetworkData::sourceNetworkID)).setter(SourceNetworkData.setter(Builder::sourceNetworkID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()}).build();
    private static final SdkField<String> SOURCE_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVpc").getter(SourceNetworkData.getter(SourceNetworkData::sourceVpc)).setter(SourceNetworkData.setter(Builder::sourceVpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVpc").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackName").getter(SourceNetworkData.getter(SourceNetworkData::stackName)).setter(SourceNetworkData.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()}).build();
    private static final SdkField<String> TARGET_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetVpc").getter(SourceNetworkData.getter(SourceNetworkData::targetVpc)).setter(SourceNetworkData.setter(Builder::targetVpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NETWORK_ID_FIELD, SOURCE_VPC_FIELD, STACK_NAME_FIELD, TARGET_VPC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceNetworkData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceNetworkID;
    private final String sourceVpc;
    private final String stackName;
    private final String targetVpc;

    private SourceNetworkData(BuilderImpl builder) {
        this.sourceNetworkID = builder.sourceNetworkID;
        this.sourceVpc = builder.sourceVpc;
        this.stackName = builder.stackName;
        this.targetVpc = builder.targetVpc;
    }

    public final String sourceNetworkID() {
        return this.sourceNetworkID;
    }

    public final String sourceVpc() {
        return this.sourceVpc;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String targetVpc() {
        return this.targetVpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNetworkID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceNetworkData)) {
            return false;
        }
        SourceNetworkData other = (SourceNetworkData)obj;
        return Objects.equals(this.sourceNetworkID(), other.sourceNetworkID()) && Objects.equals(this.sourceVpc(), other.sourceVpc()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.targetVpc(), other.targetVpc());
    }

    public final String toString() {
        return ToString.builder((String)"SourceNetworkData").add("SourceNetworkID", (Object)this.sourceNetworkID()).add("SourceVpc", (Object)this.sourceVpc()).add("StackName", (Object)this.stackName()).add("TargetVpc", (Object)this.targetVpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceNetworkID": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkID()));
            }
            case "sourceVpc": {
                return Optional.ofNullable(clazz.cast(this.sourceVpc()));
            }
            case "stackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "targetVpc": {
                return Optional.ofNullable(clazz.cast(this.targetVpc()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sourceNetworkID", SOURCE_NETWORK_ID_FIELD);
        map.put("sourceVpc", SOURCE_VPC_FIELD);
        map.put("stackName", STACK_NAME_FIELD);
        map.put("targetVpc", TARGET_VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceNetworkData, T> g) {
        return obj -> g.apply((SourceNetworkData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceNetworkID;
        private String sourceVpc;
        private String stackName;
        private String targetVpc;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceNetworkData model) {
            this.sourceNetworkID(model.sourceNetworkID);
            this.sourceVpc(model.sourceVpc);
            this.stackName(model.stackName);
            this.targetVpc(model.targetVpc);
        }

        public final String getSourceNetworkID() {
            return this.sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        public final String getSourceVpc() {
            return this.sourceVpc;
        }

        public final void setSourceVpc(String sourceVpc) {
            this.sourceVpc = sourceVpc;
        }

        @Override
        public final Builder sourceVpc(String sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getTargetVpc() {
            return this.targetVpc;
        }

        public final void setTargetVpc(String targetVpc) {
            this.targetVpc = targetVpc;
        }

        @Override
        public final Builder targetVpc(String targetVpc) {
            this.targetVpc = targetVpc;
            return this;
        }

        public SourceNetworkData build() {
            return new SourceNetworkData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceNetworkData> {
        public Builder sourceNetworkID(String var1);

        public Builder sourceVpc(String var1);

        public Builder stackName(String var1);

        public Builder targetVpc(String var1);
    }
}

