/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.SourceNetworkData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventResourceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventResourceData> {
    private static final SdkField<SourceNetworkData> SOURCE_NETWORK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceNetworkData").getter(EventResourceData.getter(EventResourceData::sourceNetworkData)).setter(EventResourceData.setter(Builder::sourceNetworkData)).constructor(SourceNetworkData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NETWORK_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventResourceData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SourceNetworkData sourceNetworkData;
    private final Type type;

    private EventResourceData(BuilderImpl builder) {
        this.sourceNetworkData = builder.sourceNetworkData;
        this.type = builder.type;
    }

    public final SourceNetworkData sourceNetworkData() {
        return this.sourceNetworkData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNetworkData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventResourceData)) {
            return false;
        }
        EventResourceData other = (EventResourceData)obj;
        return Objects.equals(this.sourceNetworkData(), other.sourceNetworkData());
    }

    public final String toString() {
        return ToString.builder((String)"EventResourceData").add("SourceNetworkData", (Object)this.sourceNetworkData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceNetworkData": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkData()));
            }
        }
        return Optional.empty();
    }

    public static EventResourceData fromSourceNetworkData(SourceNetworkData sourceNetworkData) {
        return (EventResourceData)EventResourceData.builder().sourceNetworkData(sourceNetworkData).build();
    }

    public static EventResourceData fromSourceNetworkData(Consumer<SourceNetworkData.Builder> sourceNetworkData) {
        SourceNetworkData.Builder builder = SourceNetworkData.builder();
        sourceNetworkData.accept(builder);
        return EventResourceData.fromSourceNetworkData((SourceNetworkData)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SourceNetworkData>> map = new HashMap<String, SdkField<SourceNetworkData>>();
        map.put("sourceNetworkData", SOURCE_NETWORK_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventResourceData, T> g) {
        return obj -> g.apply((EventResourceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SOURCE_NETWORK_DATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SourceNetworkData sourceNetworkData;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventResourceData model) {
            this.sourceNetworkData(model.sourceNetworkData);
        }

        public final SourceNetworkData.Builder getSourceNetworkData() {
            return this.sourceNetworkData != null ? this.sourceNetworkData.toBuilder() : null;
        }

        public final void setSourceNetworkData(SourceNetworkData.BuilderImpl sourceNetworkData) {
            SourceNetworkData oldValue = this.sourceNetworkData;
            this.sourceNetworkData = sourceNetworkData != null ? sourceNetworkData.build() : null;
            this.handleUnionValueChange(Type.SOURCE_NETWORK_DATA, oldValue, this.sourceNetworkData);
        }

        @Override
        public final Builder sourceNetworkData(SourceNetworkData sourceNetworkData) {
            SourceNetworkData oldValue = this.sourceNetworkData;
            this.sourceNetworkData = sourceNetworkData;
            this.handleUnionValueChange(Type.SOURCE_NETWORK_DATA, oldValue, this.sourceNetworkData);
            return this;
        }

        public EventResourceData build() {
            return new EventResourceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventResourceData> {
        public Builder sourceNetworkData(SourceNetworkData var1);

        default public Builder sourceNetworkData(Consumer<SourceNetworkData.Builder> sourceNetworkData) {
            return this.sourceNetworkData((SourceNetworkData)((SourceNetworkData.Builder)SourceNetworkData.builder().applyMutation(sourceNetworkData)).build());
        }
    }
}

