/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.LaunchActionsStatus;
import software.amazon.awssdk.services.drs.model.LaunchStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipatingServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipatingServer> {
    private static final SdkField<LaunchActionsStatus> LAUNCH_ACTIONS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchActionsStatus").getter(ParticipatingServer.getter(ParticipatingServer::launchActionsStatus)).setter(ParticipatingServer.setter(Builder::launchActionsStatus)).constructor(LaunchActionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchActionsStatus").build()}).build();
    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchStatus").getter(ParticipatingServer.getter(ParticipatingServer::launchStatusAsString)).setter(ParticipatingServer.setter(Builder::launchStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()}).build();
    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryInstanceID").getter(ParticipatingServer.getter(ParticipatingServer::recoveryInstanceID)).setter(ParticipatingServer.setter(Builder::recoveryInstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceID").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(ParticipatingServer.getter(ParticipatingServer::sourceServerID)).setter(ParticipatingServer.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_ACTIONS_STATUS_FIELD, LAUNCH_STATUS_FIELD, RECOVERY_INSTANCE_ID_FIELD, SOURCE_SERVER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("launchActionsStatus", LAUNCH_ACTIONS_STATUS_FIELD);
            this.put("launchStatus", LAUNCH_STATUS_FIELD);
            this.put("recoveryInstanceID", RECOVERY_INSTANCE_ID_FIELD);
            this.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final LaunchActionsStatus launchActionsStatus;
    private final String launchStatus;
    private final String recoveryInstanceID;
    private final String sourceServerID;

    private ParticipatingServer(BuilderImpl builder) {
        this.launchActionsStatus = builder.launchActionsStatus;
        this.launchStatus = builder.launchStatus;
        this.recoveryInstanceID = builder.recoveryInstanceID;
        this.sourceServerID = builder.sourceServerID;
    }

    public final LaunchActionsStatus launchActionsStatus() {
        return this.launchActionsStatus;
    }

    public final LaunchStatus launchStatus() {
        return LaunchStatus.fromValue(this.launchStatus);
    }

    public final String launchStatusAsString() {
        return this.launchStatus;
    }

    public final String recoveryInstanceID() {
        return this.recoveryInstanceID;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchActionsStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingServer)) {
            return false;
        }
        ParticipatingServer other = (ParticipatingServer)obj;
        return Objects.equals(this.launchActionsStatus(), other.launchActionsStatus()) && Objects.equals(this.launchStatusAsString(), other.launchStatusAsString()) && Objects.equals(this.recoveryInstanceID(), other.recoveryInstanceID()) && Objects.equals(this.sourceServerID(), other.sourceServerID());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipatingServer").add("LaunchActionsStatus", (Object)this.launchActionsStatus()).add("LaunchStatus", (Object)this.launchStatusAsString()).add("RecoveryInstanceID", (Object)this.recoveryInstanceID()).add("SourceServerID", (Object)this.sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launchActionsStatus": {
                return Optional.ofNullable(clazz.cast(this.launchActionsStatus()));
            }
            case "launchStatus": {
                return Optional.ofNullable(clazz.cast(this.launchStatusAsString()));
            }
            case "recoveryInstanceID": {
                return Optional.ofNullable(clazz.cast(this.recoveryInstanceID()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingServer, T> g) {
        return obj -> g.apply((ParticipatingServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LaunchActionsStatus launchActionsStatus;
        private String launchStatus;
        private String recoveryInstanceID;
        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingServer model) {
            this.launchActionsStatus(model.launchActionsStatus);
            this.launchStatus(model.launchStatus);
            this.recoveryInstanceID(model.recoveryInstanceID);
            this.sourceServerID(model.sourceServerID);
        }

        public final LaunchActionsStatus.Builder getLaunchActionsStatus() {
            return this.launchActionsStatus != null ? this.launchActionsStatus.toBuilder() : null;
        }

        public final void setLaunchActionsStatus(LaunchActionsStatus.BuilderImpl launchActionsStatus) {
            this.launchActionsStatus = launchActionsStatus != null ? launchActionsStatus.build() : null;
        }

        @Override
        public final Builder launchActionsStatus(LaunchActionsStatus launchActionsStatus) {
            this.launchActionsStatus = launchActionsStatus;
            return this;
        }

        public final String getLaunchStatus() {
            return this.launchStatus;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(LaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final String getRecoveryInstanceID() {
            return this.recoveryInstanceID;
        }

        public final void setRecoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
        }

        @Override
        public final Builder recoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public ParticipatingServer build() {
            return new ParticipatingServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipatingServer> {
        public Builder launchActionsStatus(LaunchActionsStatus var1);

        default public Builder launchActionsStatus(Consumer<LaunchActionsStatus.Builder> launchActionsStatus) {
            return this.launchActionsStatus((LaunchActionsStatus)((LaunchActionsStatus.Builder)LaunchActionsStatus.builder().applyMutation(launchActionsStatus)).build());
        }

        public Builder launchStatus(String var1);

        public Builder launchStatus(LaunchStatus var1);

        public Builder recoveryInstanceID(String var1);

        public Builder sourceServerID(String var1);
    }
}

