/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.JobLogEvent;
import software.amazon.awssdk.services.drs.model.JobLogEventData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobLog
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobLog> {
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(JobLog.getter(JobLog::eventAsString)).setter(JobLog.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<JobLogEventData> EVENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventData").getter(JobLog.getter(JobLog::eventData)).setter(JobLog.setter(Builder::eventData)).constructor(JobLogEventData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventData").build()}).build();
    private static final SdkField<String> LOG_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logDateTime").getter(JobLog.getter(JobLog::logDateTime)).setter(JobLog.setter(Builder::logDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, EVENT_DATA_FIELD, LOG_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("event", EVENT_FIELD);
            this.put("eventData", EVENT_DATA_FIELD);
            this.put("logDateTime", LOG_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String event;
    private final JobLogEventData eventData;
    private final String logDateTime;

    private JobLog(BuilderImpl builder) {
        this.event = builder.event;
        this.eventData = builder.eventData;
        this.logDateTime = builder.logDateTime;
    }

    public final JobLogEvent event() {
        return JobLogEvent.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public final JobLogEventData eventData() {
        return this.eventData;
    }

    public final String logDateTime() {
        return this.logDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventData());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobLog)) {
            return false;
        }
        JobLog other = (JobLog)obj;
        return Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.eventData(), other.eventData()) && Objects.equals(this.logDateTime(), other.logDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"JobLog").add("Event", (Object)this.eventAsString()).add("EventData", (Object)this.eventData()).add("LogDateTime", (Object)this.logDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "eventData": {
                return Optional.ofNullable(clazz.cast(this.eventData()));
            }
            case "logDateTime": {
                return Optional.ofNullable(clazz.cast(this.logDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobLog, T> g) {
        return obj -> g.apply((JobLog)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String event;
        private JobLogEventData eventData;
        private String logDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(JobLog model) {
            this.event(model.event);
            this.eventData(model.eventData);
            this.logDateTime(model.logDateTime);
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(JobLogEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final JobLogEventData.Builder getEventData() {
            return this.eventData != null ? this.eventData.toBuilder() : null;
        }

        public final void setEventData(JobLogEventData.BuilderImpl eventData) {
            this.eventData = eventData != null ? eventData.build() : null;
        }

        @Override
        public final Builder eventData(JobLogEventData eventData) {
            this.eventData = eventData;
            return this;
        }

        public final String getLogDateTime() {
            return this.logDateTime;
        }

        public final void setLogDateTime(String logDateTime) {
            this.logDateTime = logDateTime;
        }

        @Override
        public final Builder logDateTime(String logDateTime) {
            this.logDateTime = logDateTime;
            return this;
        }

        public JobLog build() {
            return new JobLog(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobLog> {
        public Builder event(String var1);

        public Builder event(JobLogEvent var1);

        public Builder eventData(JobLogEventData var1);

        default public Builder eventData(Consumer<JobLogEventData.Builder> eventData) {
            return this.eventData((JobLogEventData)((JobLogEventData.Builder)JobLogEventData.builder().applyMutation(eventData)).build());
        }

        public Builder logDateTime(String var1);
    }
}

