/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OriginEnvironment {
    ON_PREMISES("ON_PREMISES"),
    AWS("AWS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OriginEnvironment> VALUE_MAP;
    private final String value;

    private OriginEnvironment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OriginEnvironment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OriginEnvironment> knownValues() {
        EnumSet<OriginEnvironment> knownValues = EnumSet.allOf(OriginEnvironment.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OriginEnvironment.class, OriginEnvironment::toString);
    }
}

