/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.DescribeSourceNetworksRequest;
import software.amazon.awssdk.services.drs.model.DescribeSourceNetworksResponse;
import software.amazon.awssdk.services.drs.model.SourceNetwork;

public class DescribeSourceNetworksIterable
implements SdkIterable<DescribeSourceNetworksResponse> {
    private final DrsClient client;
    private final DescribeSourceNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSourceNetworksIterable(DrsClient client, DescribeSourceNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSourceNetworksResponseFetcher();
    }

    public Iterator<DescribeSourceNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SourceNetwork> items() {
        Function<DescribeSourceNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSourceNetworksResponseFetcher
    implements SyncPageFetcher<DescribeSourceNetworksResponse> {
        private DescribeSourceNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSourceNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSourceNetworksResponse nextPage(DescribeSourceNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeSourceNetworksIterable.this.client.describeSourceNetworks(DescribeSourceNetworksIterable.this.firstRequest);
            }
            return DescribeSourceNetworksIterable.this.client.describeSourceNetworks((DescribeSourceNetworksRequest)((Object)DescribeSourceNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

