/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a block storage device on the Recovery Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryInstanceDisk implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryInstanceDisk.Builder, RecoveryInstanceDisk> {
    private static final SdkField<Long> BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("bytes")
            .getter(getter(RecoveryInstanceDisk::bytes)).setter(setter(Builder::bytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytes").build()).build();

    private static final SdkField<String> EBS_VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ebsVolumeID").getter(getter(RecoveryInstanceDisk::ebsVolumeID)).setter(setter(Builder::ebsVolumeID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolumeID").build()).build();

    private static final SdkField<String> INTERNAL_DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("internalDeviceName").getter(getter(RecoveryInstanceDisk::internalDeviceName))
            .setter(setter(Builder::internalDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internalDeviceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_FIELD,
            EBS_VOLUME_ID_FIELD, INTERNAL_DEVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long bytes;

    private final String ebsVolumeID;

    private final String internalDeviceName;

    private RecoveryInstanceDisk(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.ebsVolumeID = builder.ebsVolumeID;
        this.internalDeviceName = builder.internalDeviceName;
    }

    /**
     * <p>
     * The amount of storage on the disk in bytes.
     * </p>
     * 
     * @return The amount of storage on the disk in bytes.
     */
    public final Long bytes() {
        return bytes;
    }

    /**
     * <p>
     * The EBS Volume ID of this disk.
     * </p>
     * 
     * @return The EBS Volume ID of this disk.
     */
    public final String ebsVolumeID() {
        return ebsVolumeID;
    }

    /**
     * <p>
     * The internal device name of this disk. This is the name that is visible on the machine itself and not from the
     * EC2 console.
     * </p>
     * 
     * @return The internal device name of this disk. This is the name that is visible on the machine itself and not
     *         from the EC2 console.
     */
    public final String internalDeviceName() {
        return internalDeviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bytes());
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolumeID());
        hashCode = 31 * hashCode + Objects.hashCode(internalDeviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceDisk)) {
            return false;
        }
        RecoveryInstanceDisk other = (RecoveryInstanceDisk) obj;
        return Objects.equals(bytes(), other.bytes()) && Objects.equals(ebsVolumeID(), other.ebsVolumeID())
                && Objects.equals(internalDeviceName(), other.internalDeviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryInstanceDisk").add("Bytes", bytes()).add("EbsVolumeID", ebsVolumeID())
                .add("InternalDeviceName", internalDeviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bytes":
            return Optional.ofNullable(clazz.cast(bytes()));
        case "ebsVolumeID":
            return Optional.ofNullable(clazz.cast(ebsVolumeID()));
        case "internalDeviceName":
            return Optional.ofNullable(clazz.cast(internalDeviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceDisk, T> g) {
        return obj -> g.apply((RecoveryInstanceDisk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryInstanceDisk> {
        /**
         * <p>
         * The amount of storage on the disk in bytes.
         * </p>
         * 
         * @param bytes
         *        The amount of storage on the disk in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytes(Long bytes);

        /**
         * <p>
         * The EBS Volume ID of this disk.
         * </p>
         * 
         * @param ebsVolumeID
         *        The EBS Volume ID of this disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolumeID(String ebsVolumeID);

        /**
         * <p>
         * The internal device name of this disk. This is the name that is visible on the machine itself and not from
         * the EC2 console.
         * </p>
         * 
         * @param internalDeviceName
         *        The internal device name of this disk. This is the name that is visible on the machine itself and not
         *        from the EC2 console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalDeviceName(String internalDeviceName);
    }

    static final class BuilderImpl implements Builder {
        private Long bytes;

        private String ebsVolumeID;

        private String internalDeviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceDisk model) {
            bytes(model.bytes);
            ebsVolumeID(model.ebsVolumeID);
            internalDeviceName(model.internalDeviceName);
        }

        public final Long getBytes() {
            return bytes;
        }

        public final void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        @Override
        public final Builder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public final String getEbsVolumeID() {
            return ebsVolumeID;
        }

        public final void setEbsVolumeID(String ebsVolumeID) {
            this.ebsVolumeID = ebsVolumeID;
        }

        @Override
        public final Builder ebsVolumeID(String ebsVolumeID) {
            this.ebsVolumeID = ebsVolumeID;
            return this;
        }

        public final String getInternalDeviceName() {
            return internalDeviceName;
        }

        public final void setInternalDeviceName(String internalDeviceName) {
            this.internalDeviceName = internalDeviceName;
        }

        @Override
        public final Builder internalDeviceName(String internalDeviceName) {
            this.internalDeviceName = internalDeviceName;
            return this;
        }

        @Override
        public RecoveryInstanceDisk build() {
            return new RecoveryInstanceDisk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
