/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchConfigurationTemplateResponse extends DrsResponse implements
        ToCopyableBuilder<CreateLaunchConfigurationTemplateResponse.Builder, CreateLaunchConfigurationTemplateResponse> {
    private static final SdkField<LaunchConfigurationTemplate> LAUNCH_CONFIGURATION_TEMPLATE_FIELD = SdkField
            .<LaunchConfigurationTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("launchConfigurationTemplate")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::launchConfigurationTemplate))
            .setter(setter(Builder::launchConfigurationTemplate))
            .constructor(LaunchConfigurationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LAUNCH_CONFIGURATION_TEMPLATE_FIELD));

    private final LaunchConfigurationTemplate launchConfigurationTemplate;

    private CreateLaunchConfigurationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.launchConfigurationTemplate = builder.launchConfigurationTemplate;
    }

    /**
     * <p>
     * Created Launch Configuration Template.
     * </p>
     * 
     * @return Created Launch Configuration Template.
     */
    public final LaunchConfigurationTemplate launchConfigurationTemplate() {
        return launchConfigurationTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationTemplateResponse)) {
            return false;
        }
        CreateLaunchConfigurationTemplateResponse other = (CreateLaunchConfigurationTemplateResponse) obj;
        return Objects.equals(launchConfigurationTemplate(), other.launchConfigurationTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLaunchConfigurationTemplateResponse")
                .add("LaunchConfigurationTemplate", launchConfigurationTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchConfigurationTemplate":
            return Optional.ofNullable(clazz.cast(launchConfigurationTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchConfigurationTemplateResponse, T> g) {
        return obj -> g.apply((CreateLaunchConfigurationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLaunchConfigurationTemplateResponse> {
        /**
         * <p>
         * Created Launch Configuration Template.
         * </p>
         * 
         * @param launchConfigurationTemplate
         *        Created Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationTemplate(LaunchConfigurationTemplate launchConfigurationTemplate);

        /**
         * <p>
         * Created Launch Configuration Template.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchConfigurationTemplate.Builder}
         * avoiding the need to create one manually via {@link LaunchConfigurationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchConfigurationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #launchConfigurationTemplate(LaunchConfigurationTemplate)}.
         * 
         * @param launchConfigurationTemplate
         *        a consumer that will call methods on {@link LaunchConfigurationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfigurationTemplate(LaunchConfigurationTemplate)
         */
        default Builder launchConfigurationTemplate(Consumer<LaunchConfigurationTemplate.Builder> launchConfigurationTemplate) {
            return launchConfigurationTemplate(LaunchConfigurationTemplate.builder().applyMutation(launchConfigurationTemplate)
                    .build());
        }
    }

    static final class BuilderImpl extends DrsResponse.BuilderImpl implements Builder {
        private LaunchConfigurationTemplate launchConfigurationTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationTemplateResponse model) {
            super(model);
            launchConfigurationTemplate(model.launchConfigurationTemplate);
        }

        public final LaunchConfigurationTemplate.Builder getLaunchConfigurationTemplate() {
            return launchConfigurationTemplate != null ? launchConfigurationTemplate.toBuilder() : null;
        }

        public final void setLaunchConfigurationTemplate(LaunchConfigurationTemplate.BuilderImpl launchConfigurationTemplate) {
            this.launchConfigurationTemplate = launchConfigurationTemplate != null ? launchConfigurationTemplate.build() : null;
        }

        @Override
        public final Builder launchConfigurationTemplate(LaunchConfigurationTemplate launchConfigurationTemplate) {
            this.launchConfigurationTemplate = launchConfigurationTemplate;
            return this;
        }

        @Override
        public CreateLaunchConfigurationTemplateResponse build() {
            return new CreateLaunchConfigurationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
