/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSourceNetworkStackRequest extends DrsRequest implements
        ToCopyableBuilder<AssociateSourceNetworkStackRequest.Builder, AssociateSourceNetworkStackRequest> {
    private static final SdkField<String> CFN_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cfnStackName").getter(getter(AssociateSourceNetworkStackRequest::cfnStackName))
            .setter(setter(Builder::cfnStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cfnStackName").build()).build();

    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceNetworkID").getter(getter(AssociateSourceNetworkStackRequest::sourceNetworkID))
            .setter(setter(Builder::sourceNetworkID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CFN_STACK_NAME_FIELD,
            SOURCE_NETWORK_ID_FIELD));

    private final String cfnStackName;

    private final String sourceNetworkID;

    private AssociateSourceNetworkStackRequest(BuilderImpl builder) {
        super(builder);
        this.cfnStackName = builder.cfnStackName;
        this.sourceNetworkID = builder.sourceNetworkID;
    }

    /**
     * <p>
     * CloudFormation template to associate with a Source Network.
     * </p>
     * 
     * @return CloudFormation template to associate with a Source Network.
     */
    public final String cfnStackName() {
        return cfnStackName;
    }

    /**
     * <p>
     * The Source Network ID to associate with CloudFormation template.
     * </p>
     * 
     * @return The Source Network ID to associate with CloudFormation template.
     */
    public final String sourceNetworkID() {
        return sourceNetworkID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cfnStackName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceNetworkID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSourceNetworkStackRequest)) {
            return false;
        }
        AssociateSourceNetworkStackRequest other = (AssociateSourceNetworkStackRequest) obj;
        return Objects.equals(cfnStackName(), other.cfnStackName()) && Objects.equals(sourceNetworkID(), other.sourceNetworkID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSourceNetworkStackRequest")
                .add("CfnStackName", cfnStackName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SourceNetworkID", sourceNetworkID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cfnStackName":
            return Optional.ofNullable(clazz.cast(cfnStackName()));
        case "sourceNetworkID":
            return Optional.ofNullable(clazz.cast(sourceNetworkID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSourceNetworkStackRequest, T> g) {
        return obj -> g.apply((AssociateSourceNetworkStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateSourceNetworkStackRequest> {
        /**
         * <p>
         * CloudFormation template to associate with a Source Network.
         * </p>
         * 
         * @param cfnStackName
         *        CloudFormation template to associate with a Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cfnStackName(String cfnStackName);

        /**
         * <p>
         * The Source Network ID to associate with CloudFormation template.
         * </p>
         * 
         * @param sourceNetworkID
         *        The Source Network ID to associate with CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworkID(String sourceNetworkID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private String cfnStackName;

        private String sourceNetworkID;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSourceNetworkStackRequest model) {
            super(model);
            cfnStackName(model.cfnStackName);
            sourceNetworkID(model.sourceNetworkID);
        }

        public final String getCfnStackName() {
            return cfnStackName;
        }

        public final void setCfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
        }

        @Override
        public final Builder cfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
            return this;
        }

        public final String getSourceNetworkID() {
            return sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSourceNetworkStackRequest build() {
            return new AssociateSourceNetworkStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
