/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.DrsServiceClientConfiguration;
import software.amazon.awssdk.services.drs.model.AccessDeniedException;
import software.amazon.awssdk.services.drs.model.AssociateSourceNetworkStackRequest;
import software.amazon.awssdk.services.drs.model.AssociateSourceNetworkStackResponse;
import software.amazon.awssdk.services.drs.model.ConflictException;
import software.amazon.awssdk.services.drs.model.CreateExtendedSourceServerRequest;
import software.amazon.awssdk.services.drs.model.CreateExtendedSourceServerResponse;
import software.amazon.awssdk.services.drs.model.CreateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.CreateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.CreateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.CreateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.CreateSourceNetworkRequest;
import software.amazon.awssdk.services.drs.model.CreateSourceNetworkResponse;
import software.amazon.awssdk.services.drs.model.DeleteJobRequest;
import software.amazon.awssdk.services.drs.model.DeleteJobResponse;
import software.amazon.awssdk.services.drs.model.DeleteLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.DeleteLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.DeleteRecoveryInstanceRequest;
import software.amazon.awssdk.services.drs.model.DeleteRecoveryInstanceResponse;
import software.amazon.awssdk.services.drs.model.DeleteReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.DeleteReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.DeleteSourceNetworkRequest;
import software.amazon.awssdk.services.drs.model.DeleteSourceNetworkResponse;
import software.amazon.awssdk.services.drs.model.DeleteSourceServerRequest;
import software.amazon.awssdk.services.drs.model.DeleteSourceServerResponse;
import software.amazon.awssdk.services.drs.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.drs.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.drs.model.DescribeJobsRequest;
import software.amazon.awssdk.services.drs.model.DescribeJobsResponse;
import software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesResponse;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsResponse;
import software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.drs.model.DescribeSourceNetworksRequest;
import software.amazon.awssdk.services.drs.model.DescribeSourceNetworksResponse;
import software.amazon.awssdk.services.drs.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.drs.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.drs.model.DisconnectRecoveryInstanceRequest;
import software.amazon.awssdk.services.drs.model.DisconnectRecoveryInstanceResponse;
import software.amazon.awssdk.services.drs.model.DisconnectSourceServerRequest;
import software.amazon.awssdk.services.drs.model.DisconnectSourceServerResponse;
import software.amazon.awssdk.services.drs.model.DrsException;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.services.drs.model.ExportSourceNetworkCfnTemplateRequest;
import software.amazon.awssdk.services.drs.model.ExportSourceNetworkCfnTemplateResponse;
import software.amazon.awssdk.services.drs.model.GetFailbackReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.GetFailbackReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.GetLaunchConfigurationRequest;
import software.amazon.awssdk.services.drs.model.GetLaunchConfigurationResponse;
import software.amazon.awssdk.services.drs.model.GetReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.GetReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.InitializeServiceRequest;
import software.amazon.awssdk.services.drs.model.InitializeServiceResponse;
import software.amazon.awssdk.services.drs.model.InternalServerException;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersResponse;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsResponse;
import software.amazon.awssdk.services.drs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.drs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.drs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.drs.model.RetryDataReplicationRequest;
import software.amazon.awssdk.services.drs.model.RetryDataReplicationResponse;
import software.amazon.awssdk.services.drs.model.ReverseReplicationRequest;
import software.amazon.awssdk.services.drs.model.ReverseReplicationResponse;
import software.amazon.awssdk.services.drs.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.drs.model.StartFailbackLaunchRequest;
import software.amazon.awssdk.services.drs.model.StartFailbackLaunchResponse;
import software.amazon.awssdk.services.drs.model.StartRecoveryRequest;
import software.amazon.awssdk.services.drs.model.StartRecoveryResponse;
import software.amazon.awssdk.services.drs.model.StartReplicationRequest;
import software.amazon.awssdk.services.drs.model.StartReplicationResponse;
import software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryRequest;
import software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryResponse;
import software.amazon.awssdk.services.drs.model.StartSourceNetworkReplicationRequest;
import software.amazon.awssdk.services.drs.model.StartSourceNetworkReplicationResponse;
import software.amazon.awssdk.services.drs.model.StopFailbackRequest;
import software.amazon.awssdk.services.drs.model.StopFailbackResponse;
import software.amazon.awssdk.services.drs.model.StopReplicationRequest;
import software.amazon.awssdk.services.drs.model.StopReplicationResponse;
import software.amazon.awssdk.services.drs.model.StopSourceNetworkReplicationRequest;
import software.amazon.awssdk.services.drs.model.StopSourceNetworkReplicationResponse;
import software.amazon.awssdk.services.drs.model.TagResourceRequest;
import software.amazon.awssdk.services.drs.model.TagResourceResponse;
import software.amazon.awssdk.services.drs.model.TerminateRecoveryInstancesRequest;
import software.amazon.awssdk.services.drs.model.TerminateRecoveryInstancesResponse;
import software.amazon.awssdk.services.drs.model.ThrottlingException;
import software.amazon.awssdk.services.drs.model.UninitializedAccountException;
import software.amazon.awssdk.services.drs.model.UntagResourceRequest;
import software.amazon.awssdk.services.drs.model.UntagResourceResponse;
import software.amazon.awssdk.services.drs.model.UpdateFailbackReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.UpdateFailbackReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationRequest;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationResponse;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.ValidationException;
import software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsPublisher;
import software.amazon.awssdk.services.drs.paginators.DescribeJobsPublisher;
import software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesPublisher;
import software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesPublisher;
import software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsPublisher;
import software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesPublisher;
import software.amazon.awssdk.services.drs.paginators.DescribeSourceNetworksPublisher;
import software.amazon.awssdk.services.drs.paginators.DescribeSourceServersPublisher;
import software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersPublisher;
import software.amazon.awssdk.services.drs.paginators.ListStagingAccountsPublisher;
import software.amazon.awssdk.services.drs.transform.AssociateSourceNetworkStackRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.CreateExtendedSourceServerRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.CreateLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.CreateReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.CreateSourceNetworkRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DeleteLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DeleteRecoveryInstanceRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DeleteReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DeleteSourceNetworkRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DeleteSourceServerRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeJobLogItemsRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeJobsRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeLaunchConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeRecoveryInstancesRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeRecoverySnapshotsRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeReplicationConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeSourceNetworksRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DescribeSourceServersRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DisconnectRecoveryInstanceRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.DisconnectSourceServerRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.ExportSourceNetworkCfnTemplateRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.GetFailbackReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.GetLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.GetReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.InitializeServiceRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.ListExtensibleSourceServersRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.ListStagingAccountsRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.RetryDataReplicationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.ReverseReplicationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StartFailbackLaunchRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StartRecoveryRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StartReplicationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StartSourceNetworkRecoveryRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StartSourceNetworkReplicationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StopFailbackRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StopReplicationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.StopSourceNetworkReplicationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.TerminateRecoveryInstancesRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.UpdateFailbackReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.UpdateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.UpdateLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.UpdateReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.drs.transform.UpdateReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultDrsAsyncClient
implements DrsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDrsAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final DrsServiceClientConfiguration serviceClientConfiguration;

    protected DefaultDrsAsyncClient(DrsServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateSourceNetworkStackResponse> associateSourceNetworkStack(AssociateSourceNetworkStackRequest associateSourceNetworkStackRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateSourceNetworkStackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSourceNetworkStack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSourceNetworkStackResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSourceNetworkStack").withMarshaller((Marshaller)new AssociateSourceNetworkStackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateSourceNetworkStackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$associateSourceNetworkStack$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$associateSourceNetworkStack$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateExtendedSourceServerResponse> createExtendedSourceServer(CreateExtendedSourceServerRequest createExtendedSourceServerRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, createExtendedSourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExtendedSourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExtendedSourceServerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExtendedSourceServer").withMarshaller((Marshaller)new CreateExtendedSourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createExtendedSourceServerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$createExtendedSourceServer$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$createExtendedSourceServer$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLaunchConfigurationTemplateResponse> createLaunchConfigurationTemplate(CreateLaunchConfigurationTemplateRequest createLaunchConfigurationTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, createLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLaunchConfigurationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLaunchConfigurationTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLaunchConfigurationTemplate").withMarshaller((Marshaller)new CreateLaunchConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLaunchConfigurationTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$createLaunchConfigurationTemplate$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$createLaunchConfigurationTemplate$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateReplicationConfigurationTemplateResponse> createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, createReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationConfigurationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationConfigurationTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationConfigurationTemplate").withMarshaller((Marshaller)new CreateReplicationConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createReplicationConfigurationTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$createReplicationConfigurationTemplate$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$createReplicationConfigurationTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSourceNetworkResponse> createSourceNetwork(CreateSourceNetworkRequest createSourceNetworkRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, createSourceNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSourceNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSourceNetworkResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSourceNetwork").withMarshaller((Marshaller)new CreateSourceNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSourceNetworkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$createSourceNetwork$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$createSourceNetwork$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest deleteJobRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteJobResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJob").withMarshaller((Marshaller)new DeleteJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$deleteJob$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$deleteJob$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLaunchConfigurationTemplateResponse> deleteLaunchConfigurationTemplate(DeleteLaunchConfigurationTemplateRequest deleteLaunchConfigurationTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLaunchConfigurationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLaunchConfigurationTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLaunchConfigurationTemplate").withMarshaller((Marshaller)new DeleteLaunchConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLaunchConfigurationTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$deleteLaunchConfigurationTemplate$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$deleteLaunchConfigurationTemplate$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRecoveryInstanceResponse> deleteRecoveryInstance(DeleteRecoveryInstanceRequest deleteRecoveryInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRecoveryInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRecoveryInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRecoveryInstanceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRecoveryInstance").withMarshaller((Marshaller)new DeleteRecoveryInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRecoveryInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$deleteRecoveryInstance$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$deleteRecoveryInstance$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteReplicationConfigurationTemplateResponse> deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationConfigurationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationConfigurationTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationConfigurationTemplate").withMarshaller((Marshaller)new DeleteReplicationConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteReplicationConfigurationTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$deleteReplicationConfigurationTemplate$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$deleteReplicationConfigurationTemplate$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSourceNetworkResponse> deleteSourceNetwork(DeleteSourceNetworkRequest deleteSourceNetworkRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteSourceNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSourceNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSourceNetworkResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSourceNetwork").withMarshaller((Marshaller)new DeleteSourceNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSourceNetworkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$deleteSourceNetwork$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$deleteSourceNetwork$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSourceServerResponse> deleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteSourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSourceServerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSourceServer").withMarshaller((Marshaller)new DeleteSourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSourceServerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$deleteSourceServer$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$deleteSourceServer$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeJobLogItemsResponse> describeJobLogItems(DescribeJobLogItemsRequest describeJobLogItemsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeJobLogItemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobLogItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobLogItemsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobLogItems").withMarshaller((Marshaller)new DescribeJobLogItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeJobLogItemsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeJobLogItems$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeJobLogItems$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeJobLogItemsPublisher describeJobLogItemsPaginator(DescribeJobLogItemsRequest describeJobLogItemsRequest) {
        return new DescribeJobLogItemsPublisher(this, this.applyPaginatorUserAgent(describeJobLogItemsRequest));
    }

    @Override
    public CompletableFuture<DescribeJobsResponse> describeJobs(DescribeJobsRequest describeJobsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobs").withMarshaller((Marshaller)new DescribeJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeJobs$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeJobs$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeJobsPublisher describeJobsPaginator(DescribeJobsRequest describeJobsRequest) {
        return new DescribeJobsPublisher(this, this.applyPaginatorUserAgent(describeJobsRequest));
    }

    @Override
    public CompletableFuture<DescribeLaunchConfigurationTemplatesResponse> describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeLaunchConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLaunchConfigurationTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLaunchConfigurationTemplatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLaunchConfigurationTemplates").withMarshaller((Marshaller)new DescribeLaunchConfigurationTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLaunchConfigurationTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeLaunchConfigurationTemplates$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeLaunchConfigurationTemplates$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeLaunchConfigurationTemplatesPublisher describeLaunchConfigurationTemplatesPaginator(DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest) {
        return new DescribeLaunchConfigurationTemplatesPublisher(this, this.applyPaginatorUserAgent(describeLaunchConfigurationTemplatesRequest));
    }

    @Override
    public CompletableFuture<DescribeRecoveryInstancesResponse> describeRecoveryInstances(DescribeRecoveryInstancesRequest describeRecoveryInstancesRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeRecoveryInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecoveryInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecoveryInstancesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecoveryInstances").withMarshaller((Marshaller)new DescribeRecoveryInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRecoveryInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeRecoveryInstances$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeRecoveryInstances$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeRecoveryInstancesPublisher describeRecoveryInstancesPaginator(DescribeRecoveryInstancesRequest describeRecoveryInstancesRequest) {
        return new DescribeRecoveryInstancesPublisher(this, this.applyPaginatorUserAgent(describeRecoveryInstancesRequest));
    }

    @Override
    public CompletableFuture<DescribeRecoverySnapshotsResponse> describeRecoverySnapshots(DescribeRecoverySnapshotsRequest describeRecoverySnapshotsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeRecoverySnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecoverySnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecoverySnapshotsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecoverySnapshots").withMarshaller((Marshaller)new DescribeRecoverySnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRecoverySnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeRecoverySnapshots$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeRecoverySnapshots$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeRecoverySnapshotsPublisher describeRecoverySnapshotsPaginator(DescribeRecoverySnapshotsRequest describeRecoverySnapshotsRequest) {
        return new DescribeRecoverySnapshotsPublisher(this, this.applyPaginatorUserAgent(describeRecoverySnapshotsRequest));
    }

    @Override
    public CompletableFuture<DescribeReplicationConfigurationTemplatesResponse> describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationConfigurationTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationConfigurationTemplatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationConfigurationTemplates").withMarshaller((Marshaller)new DescribeReplicationConfigurationTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReplicationConfigurationTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeReplicationConfigurationTemplates$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeReplicationConfigurationTemplates$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeReplicationConfigurationTemplatesPublisher describeReplicationConfigurationTemplatesPaginator(DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) {
        return new DescribeReplicationConfigurationTemplatesPublisher(this, this.applyPaginatorUserAgent(describeReplicationConfigurationTemplatesRequest));
    }

    @Override
    public CompletableFuture<DescribeSourceNetworksResponse> describeSourceNetworks(DescribeSourceNetworksRequest describeSourceNetworksRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeSourceNetworksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSourceNetworks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSourceNetworksResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSourceNetworks").withMarshaller((Marshaller)new DescribeSourceNetworksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSourceNetworksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeSourceNetworks$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeSourceNetworks$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeSourceNetworksPublisher describeSourceNetworksPaginator(DescribeSourceNetworksRequest describeSourceNetworksRequest) {
        return new DescribeSourceNetworksPublisher(this, this.applyPaginatorUserAgent(describeSourceNetworksRequest));
    }

    @Override
    public CompletableFuture<DescribeSourceServersResponse> describeSourceServers(DescribeSourceServersRequest describeSourceServersRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeSourceServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSourceServers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSourceServersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSourceServers").withMarshaller((Marshaller)new DescribeSourceServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSourceServersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$describeSourceServers$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$describeSourceServers$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeSourceServersPublisher describeSourceServersPaginator(DescribeSourceServersRequest describeSourceServersRequest) {
        return new DescribeSourceServersPublisher(this, this.applyPaginatorUserAgent(describeSourceServersRequest));
    }

    @Override
    public CompletableFuture<DisconnectRecoveryInstanceResponse> disconnectRecoveryInstance(DisconnectRecoveryInstanceRequest disconnectRecoveryInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, disconnectRecoveryInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectRecoveryInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectRecoveryInstanceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectRecoveryInstance").withMarshaller((Marshaller)new DisconnectRecoveryInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disconnectRecoveryInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$disconnectRecoveryInstance$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$disconnectRecoveryInstance$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisconnectSourceServerResponse> disconnectSourceServer(DisconnectSourceServerRequest disconnectSourceServerRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, disconnectSourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectSourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectSourceServerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectSourceServer").withMarshaller((Marshaller)new DisconnectSourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disconnectSourceServerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$disconnectSourceServer$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$disconnectSourceServer$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExportSourceNetworkCfnTemplateResponse> exportSourceNetworkCfnTemplate(ExportSourceNetworkCfnTemplateRequest exportSourceNetworkCfnTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, exportSourceNetworkCfnTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportSourceNetworkCfnTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportSourceNetworkCfnTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportSourceNetworkCfnTemplate").withMarshaller((Marshaller)new ExportSourceNetworkCfnTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)exportSourceNetworkCfnTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$exportSourceNetworkCfnTemplate$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$exportSourceNetworkCfnTemplate$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFailbackReplicationConfigurationResponse> getFailbackReplicationConfiguration(GetFailbackReplicationConfigurationRequest getFailbackReplicationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFailbackReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFailbackReplicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFailbackReplicationConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFailbackReplicationConfiguration").withMarshaller((Marshaller)new GetFailbackReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFailbackReplicationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$getFailbackReplicationConfiguration$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$getFailbackReplicationConfiguration$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLaunchConfigurationResponse> getLaunchConfiguration(GetLaunchConfigurationRequest getLaunchConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, getLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLaunchConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLaunchConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLaunchConfiguration").withMarshaller((Marshaller)new GetLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLaunchConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$getLaunchConfiguration$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$getLaunchConfiguration$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReplicationConfigurationResponse> getReplicationConfiguration(GetReplicationConfigurationRequest getReplicationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, getReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationConfiguration").withMarshaller((Marshaller)new GetReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReplicationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$getReplicationConfiguration$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$getReplicationConfiguration$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InitializeServiceResponse> initializeService(InitializeServiceRequest initializeServiceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, initializeServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitializeService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitializeServiceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitializeService").withMarshaller((Marshaller)new InitializeServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)initializeServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$initializeService$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$initializeService$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListExtensibleSourceServersResponse> listExtensibleSourceServers(ListExtensibleSourceServersRequest listExtensibleSourceServersRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, listExtensibleSourceServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExtensibleSourceServers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExtensibleSourceServersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExtensibleSourceServers").withMarshaller((Marshaller)new ListExtensibleSourceServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listExtensibleSourceServersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$listExtensibleSourceServers$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$listExtensibleSourceServers$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListExtensibleSourceServersPublisher listExtensibleSourceServersPaginator(ListExtensibleSourceServersRequest listExtensibleSourceServersRequest) {
        return new ListExtensibleSourceServersPublisher(this, this.applyPaginatorUserAgent(listExtensibleSourceServersRequest));
    }

    @Override
    public CompletableFuture<ListStagingAccountsResponse> listStagingAccounts(ListStagingAccountsRequest listStagingAccountsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStagingAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStagingAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStagingAccountsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStagingAccounts").withMarshaller((Marshaller)new ListStagingAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStagingAccountsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$listStagingAccounts$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$listStagingAccounts$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListStagingAccountsPublisher listStagingAccountsPaginator(ListStagingAccountsRequest listStagingAccountsRequest) {
        return new ListStagingAccountsPublisher(this, this.applyPaginatorUserAgent(listStagingAccountsRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$listTagsForResource$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$listTagsForResource$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RetryDataReplicationResponse> retryDataReplication(RetryDataReplicationRequest retryDataReplicationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, retryDataReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetryDataReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryDataReplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryDataReplication").withMarshaller((Marshaller)new RetryDataReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)retryDataReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$retryDataReplication$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$retryDataReplication$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReverseReplicationResponse> reverseReplication(ReverseReplicationRequest reverseReplicationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, reverseReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReverseReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReverseReplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReverseReplication").withMarshaller((Marshaller)new ReverseReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)reverseReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$reverseReplication$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$reverseReplication$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartFailbackLaunchResponse> startFailbackLaunch(StartFailbackLaunchRequest startFailbackLaunchRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, startFailbackLaunchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFailbackLaunch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFailbackLaunchResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFailbackLaunch").withMarshaller((Marshaller)new StartFailbackLaunchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startFailbackLaunchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$startFailbackLaunch$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$startFailbackLaunch$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartRecoveryResponse> startRecovery(StartRecoveryRequest startRecoveryRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, startRecoveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRecovery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRecoveryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRecovery").withMarshaller((Marshaller)new StartRecoveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startRecoveryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$startRecovery$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$startRecovery$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartReplicationResponse> startReplication(StartReplicationRequest startReplicationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, startReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReplication").withMarshaller((Marshaller)new StartReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$startReplication$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$startReplication$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSourceNetworkRecoveryResponse> startSourceNetworkRecovery(StartSourceNetworkRecoveryRequest startSourceNetworkRecoveryRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, startSourceNetworkRecoveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSourceNetworkRecovery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSourceNetworkRecoveryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSourceNetworkRecovery").withMarshaller((Marshaller)new StartSourceNetworkRecoveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startSourceNetworkRecoveryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$startSourceNetworkRecovery$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$startSourceNetworkRecovery$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSourceNetworkReplicationResponse> startSourceNetworkReplication(StartSourceNetworkReplicationRequest startSourceNetworkReplicationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, startSourceNetworkReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSourceNetworkReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSourceNetworkReplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSourceNetworkReplication").withMarshaller((Marshaller)new StartSourceNetworkReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startSourceNetworkReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$startSourceNetworkReplication$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$startSourceNetworkReplication$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopFailbackResponse> stopFailback(StopFailbackRequest stopFailbackRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopFailbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopFailback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopFailbackResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopFailback").withMarshaller((Marshaller)new StopFailbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopFailbackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$stopFailback$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$stopFailback$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopReplicationResponse> stopReplication(StopReplicationRequest stopReplicationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopReplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopReplication").withMarshaller((Marshaller)new StopReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$stopReplication$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$stopReplication$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopSourceNetworkReplicationResponse> stopSourceNetworkReplication(StopSourceNetworkReplicationRequest stopSourceNetworkReplicationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopSourceNetworkReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopSourceNetworkReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSourceNetworkReplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSourceNetworkReplication").withMarshaller((Marshaller)new StopSourceNetworkReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopSourceNetworkReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$stopSourceNetworkReplication$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$stopSourceNetworkReplication$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$tagResource$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$tagResource$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TerminateRecoveryInstancesResponse> terminateRecoveryInstances(TerminateRecoveryInstancesRequest terminateRecoveryInstancesRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, terminateRecoveryInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateRecoveryInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateRecoveryInstancesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateRecoveryInstances").withMarshaller((Marshaller)new TerminateRecoveryInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)terminateRecoveryInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$terminateRecoveryInstances$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$terminateRecoveryInstances$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$untagResource$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$untagResource$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFailbackReplicationConfigurationResponse> updateFailbackReplicationConfiguration(UpdateFailbackReplicationConfigurationRequest updateFailbackReplicationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFailbackReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFailbackReplicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFailbackReplicationConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFailbackReplicationConfiguration").withMarshaller((Marshaller)new UpdateFailbackReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFailbackReplicationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$updateFailbackReplicationConfiguration$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$updateFailbackReplicationConfiguration$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLaunchConfigurationResponse> updateLaunchConfiguration(UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLaunchConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLaunchConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLaunchConfiguration").withMarshaller((Marshaller)new UpdateLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLaunchConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$updateLaunchConfiguration$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$updateLaunchConfiguration$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLaunchConfigurationTemplateResponse> updateLaunchConfigurationTemplate(UpdateLaunchConfigurationTemplateRequest updateLaunchConfigurationTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLaunchConfigurationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLaunchConfigurationTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLaunchConfigurationTemplate").withMarshaller((Marshaller)new UpdateLaunchConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLaunchConfigurationTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$updateLaunchConfigurationTemplate$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$updateLaunchConfigurationTemplate$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateReplicationConfigurationResponse> updateReplicationConfiguration(UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReplicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReplicationConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReplicationConfiguration").withMarshaller((Marshaller)new UpdateReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateReplicationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$updateReplicationConfiguration$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$updateReplicationConfiguration$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateReplicationConfigurationTemplateResponse> updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultDrsAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"drs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReplicationConfigurationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReplicationConfigurationTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReplicationConfigurationTemplate").withMarshaller((Marshaller)new UpdateReplicationConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateReplicationConfigurationTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDrsAsyncClient.lambda$updateReplicationConfigurationTemplate$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDrsAsyncClient.lambda$updateReplicationConfigurationTemplate$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final DrsServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "drs";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DrsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UninitializedAccountException").exceptionBuilderSupplier(UninitializedAccountException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends DrsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.90").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DrsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateReplicationConfigurationTemplate$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReplicationConfigurationTemplate$139(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateReplicationConfigurationTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateReplicationConfiguration$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReplicationConfiguration$136(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateReplicationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLaunchConfigurationTemplate$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLaunchConfigurationTemplate$133(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLaunchConfigurationTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLaunchConfiguration$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLaunchConfiguration$130(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLaunchConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFailbackReplicationConfiguration$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFailbackReplicationConfiguration$127(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFailbackReplicationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$124(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$terminateRecoveryInstances$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateRecoveryInstances$121(List metricPublishers, MetricCollector apiCallMetricCollector, TerminateRecoveryInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$118(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopSourceNetworkReplication$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopSourceNetworkReplication$115(List metricPublishers, MetricCollector apiCallMetricCollector, StopSourceNetworkReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopReplication$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopReplication$112(List metricPublishers, MetricCollector apiCallMetricCollector, StopReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopFailback$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopFailback$109(List metricPublishers, MetricCollector apiCallMetricCollector, StopFailbackResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startSourceNetworkReplication$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSourceNetworkReplication$106(List metricPublishers, MetricCollector apiCallMetricCollector, StartSourceNetworkReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startSourceNetworkRecovery$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSourceNetworkRecovery$103(List metricPublishers, MetricCollector apiCallMetricCollector, StartSourceNetworkRecoveryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startReplication$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReplication$100(List metricPublishers, MetricCollector apiCallMetricCollector, StartReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startRecovery$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRecovery$97(List metricPublishers, MetricCollector apiCallMetricCollector, StartRecoveryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startFailbackLaunch$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFailbackLaunch$94(List metricPublishers, MetricCollector apiCallMetricCollector, StartFailbackLaunchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$reverseReplication$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$reverseReplication$91(List metricPublishers, MetricCollector apiCallMetricCollector, ReverseReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$retryDataReplication$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retryDataReplication$88(List metricPublishers, MetricCollector apiCallMetricCollector, RetryDataReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$85(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStagingAccounts$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStagingAccounts$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListStagingAccountsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listExtensibleSourceServers$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExtensibleSourceServers$79(List metricPublishers, MetricCollector apiCallMetricCollector, ListExtensibleSourceServersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$initializeService$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initializeService$76(List metricPublishers, MetricCollector apiCallMetricCollector, InitializeServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReplicationConfiguration$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationConfiguration$73(List metricPublishers, MetricCollector apiCallMetricCollector, GetReplicationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLaunchConfiguration$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLaunchConfiguration$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetLaunchConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFailbackReplicationConfiguration$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFailbackReplicationConfiguration$67(List metricPublishers, MetricCollector apiCallMetricCollector, GetFailbackReplicationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$exportSourceNetworkCfnTemplate$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportSourceNetworkCfnTemplate$64(List metricPublishers, MetricCollector apiCallMetricCollector, ExportSourceNetworkCfnTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disconnectSourceServer$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disconnectSourceServer$61(List metricPublishers, MetricCollector apiCallMetricCollector, DisconnectSourceServerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disconnectRecoveryInstance$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disconnectRecoveryInstance$58(List metricPublishers, MetricCollector apiCallMetricCollector, DisconnectRecoveryInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSourceServers$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSourceServers$55(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSourceServersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSourceNetworks$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSourceNetworks$52(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSourceNetworksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReplicationConfigurationTemplates$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationConfigurationTemplates$49(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReplicationConfigurationTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRecoverySnapshots$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRecoverySnapshots$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRecoverySnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRecoveryInstances$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRecoveryInstances$43(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRecoveryInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLaunchConfigurationTemplates$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLaunchConfigurationTemplates$40(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLaunchConfigurationTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeJobs$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobs$37(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeJobLogItems$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobLogItems$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeJobLogItemsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSourceServer$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSourceServer$31(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSourceServerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSourceNetwork$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSourceNetwork$28(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSourceNetworkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteReplicationConfigurationTemplate$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationConfigurationTemplate$25(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteReplicationConfigurationTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRecoveryInstance$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRecoveryInstance$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRecoveryInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLaunchConfigurationTemplate$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLaunchConfigurationTemplate$19(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLaunchConfigurationTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteJob$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJob$16(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSourceNetwork$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSourceNetwork$13(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSourceNetworkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createReplicationConfigurationTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationConfigurationTemplate$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateReplicationConfigurationTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLaunchConfigurationTemplate$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLaunchConfigurationTemplate$7(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLaunchConfigurationTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createExtendedSourceServer$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExtendedSourceServer$4(List metricPublishers, MetricCollector apiCallMetricCollector, CreateExtendedSourceServerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateSourceNetworkStack$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSourceNetworkStack$1(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateSourceNetworkStackResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

