/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecoveryResult {
    NOT_STARTED("NOT_STARTED"),
    IN_PROGRESS("IN_PROGRESS"),
    SUCCESS("SUCCESS"),
    FAIL("FAIL"),
    PARTIAL_SUCCESS("PARTIAL_SUCCESS"),
    ASSOCIATE_SUCCESS("ASSOCIATE_SUCCESS"),
    ASSOCIATE_FAIL("ASSOCIATE_FAIL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecoveryResult> VALUE_MAP;
    private final String value;

    private RecoveryResult(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecoveryResult fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecoveryResult> knownValues() {
        EnumSet<RecoveryResult> knownValues = EnumSet.allOf(RecoveryResult.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecoveryResult.class, RecoveryResult::toString);
    }
}

