/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.model.Account;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsResponse;

public class ListStagingAccountsIterable
implements SdkIterable<ListStagingAccountsResponse> {
    private final DrsClient client;
    private final ListStagingAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStagingAccountsIterable(DrsClient client, ListStagingAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStagingAccountsResponseFetcher();
    }

    public Iterator<ListStagingAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Account> accounts() {
        Function<ListStagingAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accounts() != null) {
                return response.accounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStagingAccountsResponseFetcher
    implements SyncPageFetcher<ListStagingAccountsResponse> {
        private ListStagingAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListStagingAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStagingAccountsResponse nextPage(ListStagingAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListStagingAccountsIterable.this.client.listStagingAccounts(ListStagingAccountsIterable.this.firstRequest);
            }
            return ListStagingAccountsIterable.this.client.listStagingAccounts((ListStagingAccountsRequest)((Object)ListStagingAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

