/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersResponse;
import software.amazon.awssdk.services.drs.model.StagingSourceServer;

public class ListExtensibleSourceServersPublisher
implements SdkPublisher<ListExtensibleSourceServersResponse> {
    private final DrsAsyncClient client;
    private final ListExtensibleSourceServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExtensibleSourceServersPublisher(DrsAsyncClient client, ListExtensibleSourceServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExtensibleSourceServersPublisher(DrsAsyncClient client, ListExtensibleSourceServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExtensibleSourceServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExtensibleSourceServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StagingSourceServer> items() {
        Function<ListExtensibleSourceServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExtensibleSourceServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExtensibleSourceServersResponseFetcher
    implements AsyncPageFetcher<ListExtensibleSourceServersResponse> {
        private ListExtensibleSourceServersResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensibleSourceServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExtensibleSourceServersResponse> nextPage(ListExtensibleSourceServersResponse previousPage) {
            if (previousPage == null) {
                return ListExtensibleSourceServersPublisher.this.client.listExtensibleSourceServers(ListExtensibleSourceServersPublisher.this.firstRequest);
            }
            return ListExtensibleSourceServersPublisher.this.client.listExtensibleSourceServers((ListExtensibleSourceServersRequest)((Object)ListExtensibleSourceServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

