/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.drs.DefaultDrsAsyncClient;
import software.amazon.awssdk.services.drs.DefaultDrsBaseClientBuilder;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.DrsAsyncClientBuilder;
import software.amazon.awssdk.services.drs.DrsServiceClientConfiguration;
import software.amazon.awssdk.services.drs.endpoints.DrsEndpointProvider;

@SdkInternalApi
final class DefaultDrsAsyncClientBuilder
extends DefaultDrsBaseClientBuilder<DrsAsyncClientBuilder, DrsAsyncClient>
implements DrsAsyncClientBuilder {
    DefaultDrsAsyncClientBuilder() {
    }

    @Override
    public DefaultDrsAsyncClientBuilder endpointProvider(DrsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DrsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDrsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DrsServiceClientConfiguration serviceClientConfiguration = DrsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultDrsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

