/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.services.drs.model.ReplicationConfigurationTemplateIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationConfigurationTemplatesRequest
extends DrsRequest
implements ToCopyableBuilder<Builder, DescribeReplicationConfigurationTemplatesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeReplicationConfigurationTemplatesRequest.getter(DescribeReplicationConfigurationTemplatesRequest::maxResults)).setter(DescribeReplicationConfigurationTemplatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeReplicationConfigurationTemplatesRequest.getter(DescribeReplicationConfigurationTemplatesRequest::nextToken)).setter(DescribeReplicationConfigurationTemplatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> REPLICATION_CONFIGURATION_TEMPLATE_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationConfigurationTemplateIDs").getter(DescribeReplicationConfigurationTemplatesRequest.getter(DescribeReplicationConfigurationTemplatesRequest::replicationConfigurationTemplateIDs)).setter(DescribeReplicationConfigurationTemplatesRequest.setter(Builder::replicationConfigurationTemplateIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationConfigurationTemplateIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REPLICATION_CONFIGURATION_TEMPLATE_I_DS_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> replicationConfigurationTemplateIDs;

    private DescribeReplicationConfigurationTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.replicationConfigurationTemplateIDs = builder.replicationConfigurationTemplateIDs;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReplicationConfigurationTemplateIDs() {
        return this.replicationConfigurationTemplateIDs != null && !(this.replicationConfigurationTemplateIDs instanceof SdkAutoConstructList);
    }

    public final List<String> replicationConfigurationTemplateIDs() {
        return this.replicationConfigurationTemplateIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationConfigurationTemplateIDs() ? this.replicationConfigurationTemplateIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationConfigurationTemplatesRequest)) {
            return false;
        }
        DescribeReplicationConfigurationTemplatesRequest other = (DescribeReplicationConfigurationTemplatesRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasReplicationConfigurationTemplateIDs() == other.hasReplicationConfigurationTemplateIDs() && Objects.equals(this.replicationConfigurationTemplateIDs(), other.replicationConfigurationTemplateIDs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationConfigurationTemplatesRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ReplicationConfigurationTemplateIDs", this.hasReplicationConfigurationTemplateIDs() ? this.replicationConfigurationTemplateIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "replicationConfigurationTemplateIDs": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigurationTemplateIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationConfigurationTemplatesRequest, T> g) {
        return obj -> g.apply((DescribeReplicationConfigurationTemplatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> replicationConfigurationTemplateIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationConfigurationTemplatesRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.replicationConfigurationTemplateIDs(model.replicationConfigurationTemplateIDs);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getReplicationConfigurationTemplateIDs() {
            if (this.replicationConfigurationTemplateIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationConfigurationTemplateIDs;
        }

        public final void setReplicationConfigurationTemplateIDs(Collection<String> replicationConfigurationTemplateIDs) {
            this.replicationConfigurationTemplateIDs = ReplicationConfigurationTemplateIDsCopier.copy(replicationConfigurationTemplateIDs);
        }

        @Override
        @Transient
        public final Builder replicationConfigurationTemplateIDs(Collection<String> replicationConfigurationTemplateIDs) {
            this.replicationConfigurationTemplateIDs = ReplicationConfigurationTemplateIDsCopier.copy(replicationConfigurationTemplateIDs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationConfigurationTemplateIDs(String ... replicationConfigurationTemplateIDs) {
            this.replicationConfigurationTemplateIDs(Arrays.asList(replicationConfigurationTemplateIDs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReplicationConfigurationTemplatesRequest build() {
            return new DescribeReplicationConfigurationTemplatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DrsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationConfigurationTemplatesRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder replicationConfigurationTemplateIDs(Collection<String> var1);

        public Builder replicationConfigurationTemplateIDs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

