/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.PITPolicyRuleUnits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PITPolicyRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PITPolicyRule> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(PITPolicyRule.getter(PITPolicyRule::enabled)).setter(PITPolicyRule.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("interval").getter(PITPolicyRule.getter(PITPolicyRule::interval)).setter(PITPolicyRule.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()}).build();
    private static final SdkField<Integer> RETENTION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionDuration").getter(PITPolicyRule.getter(PITPolicyRule::retentionDuration)).setter(PITPolicyRule.setter(Builder::retentionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionDuration").build()}).build();
    private static final SdkField<Long> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ruleID").getter(PITPolicyRule.getter(PITPolicyRule::ruleID)).setter(PITPolicyRule.setter(Builder::ruleID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleID").build()}).build();
    private static final SdkField<String> UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("units").getter(PITPolicyRule.getter(PITPolicyRule::unitsAsString)).setter(PITPolicyRule.setter(Builder::units)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, INTERVAL_FIELD, RETENTION_DURATION_FIELD, RULE_ID_FIELD, UNITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer interval;
    private final Integer retentionDuration;
    private final Long ruleID;
    private final String units;

    private PITPolicyRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.interval = builder.interval;
        this.retentionDuration = builder.retentionDuration;
        this.ruleID = builder.ruleID;
        this.units = builder.units;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final Integer retentionDuration() {
        return this.retentionDuration;
    }

    public final Long ruleID() {
        return this.ruleID;
    }

    public final PITPolicyRuleUnits units() {
        return PITPolicyRuleUnits.fromValue(this.units);
    }

    public final String unitsAsString() {
        return this.units;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleID());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PITPolicyRule)) {
            return false;
        }
        PITPolicyRule other = (PITPolicyRule)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.retentionDuration(), other.retentionDuration()) && Objects.equals(this.ruleID(), other.ruleID()) && Objects.equals(this.unitsAsString(), other.unitsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PITPolicyRule").add("Enabled", (Object)this.enabled()).add("Interval", (Object)this.interval()).add("RetentionDuration", (Object)this.retentionDuration()).add("RuleID", (Object)this.ruleID()).add("Units", (Object)this.unitsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "retentionDuration": {
                return Optional.ofNullable(clazz.cast(this.retentionDuration()));
            }
            case "ruleID": {
                return Optional.ofNullable(clazz.cast(this.ruleID()));
            }
            case "units": {
                return Optional.ofNullable(clazz.cast(this.unitsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PITPolicyRule, T> g) {
        return obj -> g.apply((PITPolicyRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer interval;
        private Integer retentionDuration;
        private Long ruleID;
        private String units;

        private BuilderImpl() {
        }

        private BuilderImpl(PITPolicyRule model) {
            this.enabled(model.enabled);
            this.interval(model.interval);
            this.retentionDuration(model.retentionDuration);
            this.ruleID(model.ruleID);
            this.units(model.units);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        @Transient
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final Integer getRetentionDuration() {
            return this.retentionDuration;
        }

        public final void setRetentionDuration(Integer retentionDuration) {
            this.retentionDuration = retentionDuration;
        }

        @Override
        @Transient
        public final Builder retentionDuration(Integer retentionDuration) {
            this.retentionDuration = retentionDuration;
            return this;
        }

        public final Long getRuleID() {
            return this.ruleID;
        }

        public final void setRuleID(Long ruleID) {
            this.ruleID = ruleID;
        }

        @Override
        @Transient
        public final Builder ruleID(Long ruleID) {
            this.ruleID = ruleID;
            return this;
        }

        public final String getUnits() {
            return this.units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        @Transient
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        @Override
        @Transient
        public final Builder units(PITPolicyRuleUnits units) {
            this.units(units == null ? null : units.toString());
            return this;
        }

        public PITPolicyRule build() {
            return new PITPolicyRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PITPolicyRule> {
        public Builder enabled(Boolean var1);

        public Builder interval(Integer var1);

        public Builder retentionDuration(Integer var1);

        public Builder ruleID(Long var1);

        public Builder units(String var1);

        public Builder units(PITPolicyRuleUnits var1);
    }
}

