/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.VolumeToConversionMapCopier;
import software.amazon.awssdk.services.drs.model.VolumeToSizeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversionProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversionProperties> {
    private static final SdkField<String> DATA_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataTimestamp").getter(ConversionProperties.getter(ConversionProperties::dataTimestamp)).setter(ConversionProperties.setter(Builder::dataTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTimestamp").build()}).build();
    private static final SdkField<Boolean> FORCE_UEFI_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceUefi").getter(ConversionProperties.getter(ConversionProperties::forceUefi)).setter(ConversionProperties.setter(Builder::forceUefi)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceUefi").build()}).build();
    private static final SdkField<String> ROOT_VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootVolumeName").getter(ConversionProperties.getter(ConversionProperties::rootVolumeName)).setter(ConversionProperties.setter(Builder::rootVolumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootVolumeName").build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> VOLUME_TO_CONVERSION_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("volumeToConversionMap").getter(ConversionProperties.getter(ConversionProperties::volumeToConversionMap)).setter(ConversionProperties.setter(Builder::volumeToConversionMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeToConversionMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, Long>> VOLUME_TO_VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("volumeToVolumeSize").getter(ConversionProperties.getter(ConversionProperties::volumeToVolumeSize)).setter(ConversionProperties.setter(Builder::volumeToVolumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeToVolumeSize").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TIMESTAMP_FIELD, FORCE_UEFI_FIELD, ROOT_VOLUME_NAME_FIELD, VOLUME_TO_CONVERSION_MAP_FIELD, VOLUME_TO_VOLUME_SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataTimestamp;
    private final Boolean forceUefi;
    private final String rootVolumeName;
    private final Map<String, Map<String, String>> volumeToConversionMap;
    private final Map<String, Long> volumeToVolumeSize;

    private ConversionProperties(BuilderImpl builder) {
        this.dataTimestamp = builder.dataTimestamp;
        this.forceUefi = builder.forceUefi;
        this.rootVolumeName = builder.rootVolumeName;
        this.volumeToConversionMap = builder.volumeToConversionMap;
        this.volumeToVolumeSize = builder.volumeToVolumeSize;
    }

    public final String dataTimestamp() {
        return this.dataTimestamp;
    }

    public final Boolean forceUefi() {
        return this.forceUefi;
    }

    public final String rootVolumeName() {
        return this.rootVolumeName;
    }

    public final boolean hasVolumeToConversionMap() {
        return this.volumeToConversionMap != null && !(this.volumeToConversionMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> volumeToConversionMap() {
        return this.volumeToConversionMap;
    }

    public final boolean hasVolumeToVolumeSize() {
        return this.volumeToVolumeSize != null && !(this.volumeToVolumeSize instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> volumeToVolumeSize() {
        return this.volumeToVolumeSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceUefi());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeToConversionMap() ? this.volumeToConversionMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeToVolumeSize() ? this.volumeToVolumeSize() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionProperties)) {
            return false;
        }
        ConversionProperties other = (ConversionProperties)obj;
        return Objects.equals(this.dataTimestamp(), other.dataTimestamp()) && Objects.equals(this.forceUefi(), other.forceUefi()) && Objects.equals(this.rootVolumeName(), other.rootVolumeName()) && this.hasVolumeToConversionMap() == other.hasVolumeToConversionMap() && Objects.equals(this.volumeToConversionMap(), other.volumeToConversionMap()) && this.hasVolumeToVolumeSize() == other.hasVolumeToVolumeSize() && Objects.equals(this.volumeToVolumeSize(), other.volumeToVolumeSize());
    }

    public final String toString() {
        return ToString.builder((String)"ConversionProperties").add("DataTimestamp", (Object)this.dataTimestamp()).add("ForceUefi", (Object)this.forceUefi()).add("RootVolumeName", (Object)this.rootVolumeName()).add("VolumeToConversionMap", this.hasVolumeToConversionMap() ? this.volumeToConversionMap() : null).add("VolumeToVolumeSize", this.hasVolumeToVolumeSize() ? this.volumeToVolumeSize() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataTimestamp": {
                return Optional.ofNullable(clazz.cast(this.dataTimestamp()));
            }
            case "forceUefi": {
                return Optional.ofNullable(clazz.cast(this.forceUefi()));
            }
            case "rootVolumeName": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeName()));
            }
            case "volumeToConversionMap": {
                return Optional.ofNullable(clazz.cast(this.volumeToConversionMap()));
            }
            case "volumeToVolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeToVolumeSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversionProperties, T> g) {
        return obj -> g.apply((ConversionProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataTimestamp;
        private Boolean forceUefi;
        private String rootVolumeName;
        private Map<String, Map<String, String>> volumeToConversionMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Long> volumeToVolumeSize = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionProperties model) {
            this.dataTimestamp(model.dataTimestamp);
            this.forceUefi(model.forceUefi);
            this.rootVolumeName(model.rootVolumeName);
            this.volumeToConversionMap(model.volumeToConversionMap);
            this.volumeToVolumeSize(model.volumeToVolumeSize);
        }

        public final String getDataTimestamp() {
            return this.dataTimestamp;
        }

        public final void setDataTimestamp(String dataTimestamp) {
            this.dataTimestamp = dataTimestamp;
        }

        @Override
        public final Builder dataTimestamp(String dataTimestamp) {
            this.dataTimestamp = dataTimestamp;
            return this;
        }

        public final Boolean getForceUefi() {
            return this.forceUefi;
        }

        public final void setForceUefi(Boolean forceUefi) {
            this.forceUefi = forceUefi;
        }

        @Override
        public final Builder forceUefi(Boolean forceUefi) {
            this.forceUefi = forceUefi;
            return this;
        }

        public final String getRootVolumeName() {
            return this.rootVolumeName;
        }

        public final void setRootVolumeName(String rootVolumeName) {
            this.rootVolumeName = rootVolumeName;
        }

        @Override
        public final Builder rootVolumeName(String rootVolumeName) {
            this.rootVolumeName = rootVolumeName;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getVolumeToConversionMap() {
            if (this.volumeToConversionMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.volumeToConversionMap;
        }

        public final void setVolumeToConversionMap(Map<String, ? extends Map<String, String>> volumeToConversionMap) {
            this.volumeToConversionMap = VolumeToConversionMapCopier.copy(volumeToConversionMap);
        }

        @Override
        public final Builder volumeToConversionMap(Map<String, ? extends Map<String, String>> volumeToConversionMap) {
            this.volumeToConversionMap = VolumeToConversionMapCopier.copy(volumeToConversionMap);
            return this;
        }

        public final Map<String, Long> getVolumeToVolumeSize() {
            if (this.volumeToVolumeSize instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.volumeToVolumeSize;
        }

        public final void setVolumeToVolumeSize(Map<String, Long> volumeToVolumeSize) {
            this.volumeToVolumeSize = VolumeToSizeMapCopier.copy(volumeToVolumeSize);
        }

        @Override
        public final Builder volumeToVolumeSize(Map<String, Long> volumeToVolumeSize) {
            this.volumeToVolumeSize = VolumeToSizeMapCopier.copy(volumeToVolumeSize);
            return this;
        }

        public ConversionProperties build() {
            return new ConversionProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversionProperties> {
        public Builder dataTimestamp(String var1);

        public Builder forceUefi(Boolean var1);

        public Builder rootVolumeName(String var1);

        public Builder volumeToConversionMap(Map<String, ? extends Map<String, String>> var1);

        public Builder volumeToVolumeSize(Map<String, Long> var1);
    }
}

