/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersResponse;
import software.amazon.awssdk.services.drs.model.StagingSourceServer;

public class ListExtensibleSourceServersIterable
implements SdkIterable<ListExtensibleSourceServersResponse> {
    private final DrsClient client;
    private final ListExtensibleSourceServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExtensibleSourceServersIterable(DrsClient client, ListExtensibleSourceServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExtensibleSourceServersResponseFetcher();
    }

    public Iterator<ListExtensibleSourceServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StagingSourceServer> items() {
        Function<ListExtensibleSourceServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExtensibleSourceServersResponseFetcher
    implements SyncPageFetcher<ListExtensibleSourceServersResponse> {
        private ListExtensibleSourceServersResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensibleSourceServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExtensibleSourceServersResponse nextPage(ListExtensibleSourceServersResponse previousPage) {
            if (previousPage == null) {
                return ListExtensibleSourceServersIterable.this.client.listExtensibleSourceServers(ListExtensibleSourceServersIterable.this.firstRequest);
            }
            return ListExtensibleSourceServersIterable.this.client.listExtensibleSourceServers((ListExtensibleSourceServersRequest)((Object)ListExtensibleSourceServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

