/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticAsyncClient;
import software.amazon.awssdk.services.docdbelastic.internal.UserAgentUtils;
import software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceAction;

public class ListPendingMaintenanceActionsPublisher
implements SdkPublisher<ListPendingMaintenanceActionsResponse> {
    private final DocDbElasticAsyncClient client;
    private final ListPendingMaintenanceActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPendingMaintenanceActionsPublisher(DocDbElasticAsyncClient client, ListPendingMaintenanceActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPendingMaintenanceActionsPublisher(DocDbElasticAsyncClient client, ListPendingMaintenanceActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPendingMaintenanceActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPendingMaintenanceActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions() {
        Function<ListPendingMaintenanceActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourcePendingMaintenanceActions() != null) {
                return response.resourcePendingMaintenanceActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPendingMaintenanceActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPendingMaintenanceActionsResponseFetcher
    implements AsyncPageFetcher<ListPendingMaintenanceActionsResponse> {
        private ListPendingMaintenanceActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPendingMaintenanceActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPendingMaintenanceActionsResponse> nextPage(ListPendingMaintenanceActionsResponse previousPage) {
            if (previousPage == null) {
                return ListPendingMaintenanceActionsPublisher.this.client.listPendingMaintenanceActions(ListPendingMaintenanceActionsPublisher.this.firstRequest);
            }
            return ListPendingMaintenanceActionsPublisher.this.client.listPendingMaintenanceActions((ListPendingMaintenanceActionsRequest)((Object)ListPendingMaintenanceActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

