/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterSnapshotsRequest
extends DocDbElasticRequest
implements ToCopyableBuilder<Builder, ListClusterSnapshotsRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ListClusterSnapshotsRequest.getter(ListClusterSnapshotsRequest::clusterArn)).setter(ListClusterSnapshotsRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListClusterSnapshotsRequest.getter(ListClusterSnapshotsRequest::maxResults)).setter(ListClusterSnapshotsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListClusterSnapshotsRequest.getter(ListClusterSnapshotsRequest::nextToken)).setter(ListClusterSnapshotsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotType").getter(ListClusterSnapshotsRequest.getter(ListClusterSnapshotsRequest::snapshotType)).setter(ListClusterSnapshotsRequest.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("snapshotType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SNAPSHOT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterArn", CLUSTER_ARN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("snapshotType", SNAPSHOT_TYPE_FIELD);
        }
    });
    private final String clusterArn;
    private final Integer maxResults;
    private final String nextToken;
    private final String snapshotType;

    private ListClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.snapshotType = builder.snapshotType;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String snapshotType() {
        return this.snapshotType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterSnapshotsRequest)) {
            return false;
        }
        ListClusterSnapshotsRequest other = (ListClusterSnapshotsRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.snapshotType(), other.snapshotType());
    }

    public final String toString() {
        return ToString.builder((String)"ListClusterSnapshotsRequest").add("ClusterArn", (Object)this.clusterArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SnapshotType", (Object)this.snapshotType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "snapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((ListClusterSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbElasticRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private Integer maxResults;
        private String nextToken;
        private String snapshotType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterSnapshotsRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.snapshotType(model.snapshotType);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClusterSnapshotsRequest build() {
            return new ListClusterSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DocDbElasticRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClusterSnapshotsRequest> {
        public Builder clusterArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder snapshotType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

