/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticClient;
import software.amazon.awssdk.services.docdbelastic.internal.UserAgentUtils;
import software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceAction;

public class ListPendingMaintenanceActionsIterable
implements SdkIterable<ListPendingMaintenanceActionsResponse> {
    private final DocDbElasticClient client;
    private final ListPendingMaintenanceActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPendingMaintenanceActionsIterable(DocDbElasticClient client, ListPendingMaintenanceActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPendingMaintenanceActionsResponseFetcher();
    }

    public Iterator<ListPendingMaintenanceActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions() {
        Function<ListPendingMaintenanceActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourcePendingMaintenanceActions() != null) {
                return response.resourcePendingMaintenanceActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPendingMaintenanceActionsResponseFetcher
    implements SyncPageFetcher<ListPendingMaintenanceActionsResponse> {
        private ListPendingMaintenanceActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPendingMaintenanceActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPendingMaintenanceActionsResponse nextPage(ListPendingMaintenanceActionsResponse previousPage) {
            if (previousPage == null) {
                return ListPendingMaintenanceActionsIterable.this.client.listPendingMaintenanceActions(ListPendingMaintenanceActionsIterable.this.firstRequest);
            }
            return ListPendingMaintenanceActionsIterable.this.client.listPendingMaintenanceActions((ListPendingMaintenanceActionsRequest)((Object)ListPendingMaintenanceActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

