/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticClient;
import software.amazon.awssdk.services.docdbelastic.internal.UserAgentUtils;
import software.amazon.awssdk.services.docdbelastic.model.ClusterSnapshotInList;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse;

public class ListClusterSnapshotsIterable
implements SdkIterable<ListClusterSnapshotsResponse> {
    private final DocDbElasticClient client;
    private final ListClusterSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterSnapshotsIterable(DocDbElasticClient client, ListClusterSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClusterSnapshotsResponseFetcher();
    }

    public Iterator<ListClusterSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterSnapshotInList> snapshots() {
        Function<ListClusterSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterSnapshotsResponseFetcher
    implements SyncPageFetcher<ListClusterSnapshotsResponse> {
        private ListClusterSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterSnapshotsResponse nextPage(ListClusterSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterSnapshotsIterable.this.client.listClusterSnapshots(ListClusterSnapshotsIterable.this.firstRequest);
            }
            return ListClusterSnapshotsIterable.this.client.listClusterSnapshots((ListClusterSnapshotsRequest)((Object)ListClusterSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

