/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbInstanceRequest
extends DocDbRequest
implements ToCopyableBuilder<Builder, ModifyDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbInstanceIdentifier)).setter(ModifyDbInstanceRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbInstanceClass)).setter(ModifyDbInstanceRequest.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::applyImmediately)).setter(ModifyDbInstanceRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::preferredMaintenanceWindow)).setter(ModifyDbInstanceRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::autoMinorVersionUpgrade)).setter(ModifyDbInstanceRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> NEW_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::newDBInstanceIdentifier)).setter(ModifyDbInstanceRequest.setter(Builder::newDBInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBInstanceIdentifier").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::caCertificateIdentifier)).setter(ModifyDbInstanceRequest.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build()}).build();
    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::promotionTier)).setter(ModifyDbInstanceRequest.setter(Builder::promotionTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD, APPLY_IMMEDIATELY_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, NEW_DB_INSTANCE_IDENTIFIER_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, PROMOTION_TIER_FIELD));
    private final String dbInstanceIdentifier;
    private final String dbInstanceClass;
    private final Boolean applyImmediately;
    private final String preferredMaintenanceWindow;
    private final Boolean autoMinorVersionUpgrade;
    private final String newDBInstanceIdentifier;
    private final String caCertificateIdentifier;
    private final Integer promotionTier;

    private ModifyDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.applyImmediately = builder.applyImmediately;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.newDBInstanceIdentifier = builder.newDBInstanceIdentifier;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.promotionTier = builder.promotionTier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String newDBInstanceIdentifier() {
        return this.newDBInstanceIdentifier;
    }

    public String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public Integer promotionTier() {
        return this.promotionTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.promotionTier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbInstanceRequest)) {
            return false;
        }
        ModifyDbInstanceRequest other = (ModifyDbInstanceRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.newDBInstanceIdentifier(), other.newDBInstanceIdentifier()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier()) && Objects.equals(this.promotionTier(), other.promotionTier());
    }

    public String toString() {
        return ToString.builder((String)"ModifyDbInstanceRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("ApplyImmediately", (Object)this.applyImmediately()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("NewDBInstanceIdentifier", (Object)this.newDBInstanceIdentifier()).add("CACertificateIdentifier", (Object)this.caCertificateIdentifier()).add("PromotionTier", (Object)this.promotionTier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "NewDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.newDBInstanceIdentifier()));
            }
            case "CACertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
            case "PromotionTier": {
                return Optional.ofNullable(clazz.cast(this.promotionTier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbInstanceRequest, T> g) {
        return obj -> g.apply((ModifyDbInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String dbInstanceClass;
        private Boolean applyImmediately;
        private String preferredMaintenanceWindow;
        private Boolean autoMinorVersionUpgrade;
        private String newDBInstanceIdentifier;
        private String caCertificateIdentifier;
        private Integer promotionTier;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbInstanceRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbInstanceClass(model.dbInstanceClass);
            this.applyImmediately(model.applyImmediately);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.newDBInstanceIdentifier(model.newDBInstanceIdentifier);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
            this.promotionTier(model.promotionTier);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getNewDBInstanceIdentifier() {
            return this.newDBInstanceIdentifier;
        }

        @Override
        public final Builder newDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
            return this;
        }

        public final void setNewDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbInstanceRequest build() {
            return new ModifyDbInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder applyImmediately(Boolean var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder newDBInstanceIdentifier(String var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder promotionTier(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

