/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DocDbResponse;
import software.amazon.awssdk.services.docdb.model.PendingMaintenanceActionsCopier;
import software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePendingMaintenanceActionsResponse
extends DocDbResponse
implements ToCopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
    private static final SdkField<List<ResourcePendingMaintenanceActions>> PENDING_MAINTENANCE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribePendingMaintenanceActionsResponse.getter(DescribePendingMaintenanceActionsResponse::pendingMaintenanceActions)).setter(DescribePendingMaintenanceActionsResponse.setter(Builder::pendingMaintenanceActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenanceActions").build(), ListTrait.builder().memberLocationName("ResourcePendingMaintenanceActions").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePendingMaintenanceActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePendingMaintenanceActions").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribePendingMaintenanceActionsResponse.getter(DescribePendingMaintenanceActionsResponse::marker)).setter(DescribePendingMaintenanceActionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_MAINTENANCE_ACTIONS_FIELD, MARKER_FIELD));
    private final List<ResourcePendingMaintenanceActions> pendingMaintenanceActions;
    private final String marker;

    private DescribePendingMaintenanceActionsResponse(BuilderImpl builder) {
        super(builder);
        this.pendingMaintenanceActions = builder.pendingMaintenanceActions;
        this.marker = builder.marker;
    }

    public List<ResourcePendingMaintenanceActions> pendingMaintenanceActions() {
        return this.pendingMaintenanceActions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingMaintenanceActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingMaintenanceActionsResponse)) {
            return false;
        }
        DescribePendingMaintenanceActionsResponse other = (DescribePendingMaintenanceActionsResponse)((Object)obj);
        return Objects.equals(this.pendingMaintenanceActions(), other.pendingMaintenanceActions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribePendingMaintenanceActionsResponse").add("PendingMaintenanceActions", this.pendingMaintenanceActions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PendingMaintenanceActions": {
                return Optional.ofNullable(clazz.cast(this.pendingMaintenanceActions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePendingMaintenanceActionsResponse, T> g) {
        return obj -> g.apply((DescribePendingMaintenanceActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbResponse.BuilderImpl
    implements Builder {
        private List<ResourcePendingMaintenanceActions> pendingMaintenanceActions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingMaintenanceActionsResponse model) {
            super(model);
            this.pendingMaintenanceActions(model.pendingMaintenanceActions);
            this.marker(model.marker);
        }

        public final Collection<ResourcePendingMaintenanceActions.Builder> getPendingMaintenanceActions() {
            return this.pendingMaintenanceActions != null ? (Collection)this.pendingMaintenanceActions.stream().map(ResourcePendingMaintenanceActions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copy(pendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... pendingMaintenanceActions) {
            this.pendingMaintenanceActions(Arrays.asList(pendingMaintenanceActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(Consumer<ResourcePendingMaintenanceActions.Builder> ... pendingMaintenanceActions) {
            this.pendingMaintenanceActions(Stream.of(pendingMaintenanceActions).map(c -> (ResourcePendingMaintenanceActions)((ResourcePendingMaintenanceActions.Builder)ResourcePendingMaintenanceActions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions.BuilderImpl> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copyFromBuilder(pendingMaintenanceActions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribePendingMaintenanceActionsResponse build() {
            return new DescribePendingMaintenanceActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
        public Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> var1);

        public Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... var1);

        public Builder pendingMaintenanceActions(Consumer<ResourcePendingMaintenanceActions.Builder> ... var1);

        public Builder marker(String var1);
    }
}

