/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.LogTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingCloudwatchLogsExports
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingCloudwatchLogsExports> {
    private static final SdkField<List<String>> LOG_TYPES_TO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PendingCloudwatchLogsExports.getter(PendingCloudwatchLogsExports::logTypesToEnable)).setter(PendingCloudwatchLogsExports.setter(Builder::logTypesToEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToEnable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_TYPES_TO_DISABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PendingCloudwatchLogsExports.getter(PendingCloudwatchLogsExports::logTypesToDisable)).setter(PendingCloudwatchLogsExports.setter(Builder::logTypesToDisable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToDisable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPES_TO_ENABLE_FIELD, LOG_TYPES_TO_DISABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> logTypesToEnable;
    private final List<String> logTypesToDisable;

    private PendingCloudwatchLogsExports(BuilderImpl builder) {
        this.logTypesToEnable = builder.logTypesToEnable;
        this.logTypesToDisable = builder.logTypesToDisable;
    }

    public List<String> logTypesToEnable() {
        return this.logTypesToEnable;
    }

    public List<String> logTypesToDisable() {
        return this.logTypesToDisable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypesToEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypesToDisable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingCloudwatchLogsExports)) {
            return false;
        }
        PendingCloudwatchLogsExports other = (PendingCloudwatchLogsExports)obj;
        return Objects.equals(this.logTypesToEnable(), other.logTypesToEnable()) && Objects.equals(this.logTypesToDisable(), other.logTypesToDisable());
    }

    public String toString() {
        return ToString.builder((String)"PendingCloudwatchLogsExports").add("LogTypesToEnable", this.logTypesToEnable()).add("LogTypesToDisable", this.logTypesToDisable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogTypesToEnable": {
                return Optional.ofNullable(clazz.cast(this.logTypesToEnable()));
            }
            case "LogTypesToDisable": {
                return Optional.ofNullable(clazz.cast(this.logTypesToDisable()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingCloudwatchLogsExports, T> g) {
        return obj -> g.apply((PendingCloudwatchLogsExports)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> logTypesToEnable = DefaultSdkAutoConstructList.getInstance();
        private List<String> logTypesToDisable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PendingCloudwatchLogsExports model) {
            this.logTypesToEnable(model.logTypesToEnable);
            this.logTypesToDisable(model.logTypesToDisable);
        }

        public final Collection<String> getLogTypesToEnable() {
            return this.logTypesToEnable;
        }

        @Override
        public final Builder logTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToEnable(String ... logTypesToEnable) {
            this.logTypesToEnable(Arrays.asList(logTypesToEnable));
            return this;
        }

        public final void setLogTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
        }

        public final Collection<String> getLogTypesToDisable() {
            return this.logTypesToDisable;
        }

        @Override
        public final Builder logTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToDisable(String ... logTypesToDisable) {
            this.logTypesToDisable(Arrays.asList(logTypesToDisable));
            return this;
        }

        public final void setLogTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
        }

        public PendingCloudwatchLogsExports build() {
            return new PendingCloudwatchLogsExports(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingCloudwatchLogsExports> {
        public Builder logTypesToEnable(Collection<String> var1);

        public Builder logTypesToEnable(String ... var1);

        public Builder logTypesToDisable(Collection<String> var1);

        public Builder logTypesToDisable(String ... var1);
    }
}

