/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DBCluster;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;

public class DescribeDBClustersIterable
implements SdkIterable<DescribeDbClustersResponse> {
    private final DocDbClient client;
    private final DescribeDbClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClustersIterable(DocDbClient client, DescribeDbClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbClustersResponseFetcher();
    }

    public Iterator<DescribeDbClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBCluster> dbClusters() {
        Function<DescribeDbClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusters() != null) {
                return response.dbClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDBClustersIterable resume(DescribeDbClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBClustersIterable(this.client, (DescribeDbClustersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBClustersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDbClustersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDbClustersResponseFetcher
    implements SyncPageFetcher<DescribeDbClustersResponse> {
        private DescribeDbClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClustersResponse nextPage(DescribeDbClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClustersIterable.this.client.describeDBClusters(DescribeDBClustersIterable.this.firstRequest);
            }
            return DescribeDBClustersIterable.this.client.describeDBClusters((DescribeDbClustersRequest)((Object)DescribeDBClustersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

